/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.Equipment;
import com.wgcloud.entity.HostGroup;
import com.wgcloud.mapper.EquipmentMapper;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class EquipmentService {
    @Autowired
    private EquipmentMapper equipmentMapper;
    @Autowired
    private LogInfoService logInfoService;
    @Resource
    private HostGroupService hostGroupService;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.equipmentMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(Equipment equipment) throws Exception {
        equipment.setId(UUIDUtil.getUUID());
        equipment.setCreateTime(new Date());
        this.equipmentMapper.save(equipment);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.equipmentMapper.deleteById(id);
    }

    public void updateById(Equipment equipment) throws Exception {
        this.equipmentMapper.updateById(equipment);
    }

    public Equipment selectById(String id) throws Exception {
        return this.equipmentMapper.selectById(id);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.equipmentMapper.countByParams(params);
    }

    public List<HostGroup> setGroupInList(List<Equipment> recordList, Model model, HttpServletRequest request) throws Exception {
        HashMap params = new HashMap();
        List hostGroupList = this.hostGroupService.selectAllByParams(params, request);
        model.addAttribute("hostGroupList", (Object)hostGroupList);
        HashMap<String, String> hostGroupMap = new HashMap<String, String>();
        for (HostGroup hostGroup : hostGroupList) {
            hostGroupMap.put(hostGroup.getId(), hostGroup.getGroupName());
        }
        for (Equipment appInfo : recordList) {
            if (StringUtils.isEmpty((CharSequence)appInfo.getGroupId())) continue;
            String groupNames = "";
            for (String groupId : appInfo.getGroupId().split(",")) {
                if (!hostGroupMap.containsKey(groupId)) continue;
                groupNames = groupNames + (String)hostGroupMap.get(groupId) + ",";
            }
            if (groupNames.endsWith(",")) {
                groupNames = groupNames.substring(0, groupNames.length() - 1);
            }
            appInfo.setGroupId(groupNames);
        }
        return hostGroupList;
    }

    public void saveGroupId(String ids, String[] groupIdsArr, HttpServletRequest request) throws Exception {
        List hostGroupList = new ArrayList();
        if (null != groupIdsArr && groupIdsArr.length > 0) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("groupIds", groupIdsArr);
            hostGroupList = this.hostGroupService.selectAllByParams(params, request);
        }
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            Equipment ho = null;
            for (String id : ids.split(",")) {
                ho = this.selectById(id);
                if (hostGroupList.size() > 0) {
                    ho.setGroupId(StringUtils.join((Object[])groupIdsArr, (String)","));
                } else {
                    ho.setGroupId("");
                }
                this.updateById(ho);
                this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + "\u8bbe\u7f6e\u8d44\u4ea7\u6807\u7b7e\uff1a" + ho.getName(), "\u6807\u7b7e\uff1a" + this.hostGroupService.returnGroupNames(hostGroupList), "2");
            }
        }
    }

    public void updateToTargetAccount(Map<String, Object> params) throws Exception {
        this.equipmentMapper.updateToTargetAccount(params);
    }

    public void saveLog(HttpServletRequest request, String action, Equipment equipment) {
        if (null == equipment) {
            return;
        }
        this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + action + "\u8d44\u4ea7\u4fe1\u606f\uff1a" + equipment.getName(), "\u8d44\u4ea7\u578b\u53f7\uff1a" + equipment.getXinghao(), "2");
    }

    public String goLambdaFunc() {
        String[] str = new String[]{"a", "ba", "cc", "dd"};
        Arrays.sort(str, new /* Unavailable Anonymous Inner Class!! */);
        String[] str1 = new String[]{"a", "ba", "cc", "dd"};
        Arrays.sort(str1, (o1, o2) -> Integer.compare(o1.length(), o1.length()));
        return "";
    }
}

