/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.alibaba.excel.EasyExcel;
import com.wgcloud.dto.EquipmentExcelDto;
import com.wgcloud.dto.PasswdInfoExcelDto;
import com.wgcloud.dto.WorkInfoExcelDto;
import com.wgcloud.entity.Equipment;
import com.wgcloud.entity.PasswdInfo;
import com.wgcloud.entity.WorkFileInfo;
import com.wgcloud.entity.WorkInfo;
import com.wgcloud.service.WorkFileInfoService;
import com.wgcloud.service.WorkInfoService;
import com.wgcloud.util.DateUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExcelExportService {
    private static final Logger logger = LoggerFactory.getLogger(ExcelExportService.class);
    @Autowired
    private WorkFileInfoService workFileInfoService;
    @Resource
    private WorkInfoService workInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportEquipmentListExcel(List<Equipment> equipmentList, HttpServletResponse response) {
        Object out = null;
        try {
            ArrayList<EquipmentExcelDto> excelList = new ArrayList<EquipmentExcelDto>();
            for (Equipment equipment : equipmentList) {
                EquipmentExcelDto dto = new EquipmentExcelDto();
                dto.setCreateTime(DateUtil.getDateTimeString((Date)equipment.getCreateTime()));
                dto.setGroupId(equipment.getGroupId());
                dto.setRemark(equipment.getRemark());
                dto.setAccount(equipment.getAccount());
                dto.setCode(equipment.getCode());
                dto.setCaigouDate(equipment.getCaigouDate());
                dto.setDept(equipment.getDept());
                dto.setGongyingshang(equipment.getGongyingshang());
                dto.setName(equipment.getName());
                dto.setPerson(equipment.getPerson());
                dto.setPrice(equipment.getPrice() + "");
                dto.setWeibaoDate(equipment.getWeibaoDate());
                dto.setXinghao(equipment.getXinghao());
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_\u8d44\u4ea7\u8bbe\u5907";
            response.setContentType("application/vnd.ms-exce");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), EquipmentExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPasswdInfoListExcel(List<PasswdInfo> passwdInfoList, HttpServletResponse response) {
        Object out = null;
        try {
            ArrayList<PasswdInfoExcelDto> excelList = new ArrayList<PasswdInfoExcelDto>();
            for (PasswdInfo passwdInfo : passwdInfoList) {
                PasswdInfoExcelDto dto = new PasswdInfoExcelDto();
                dto.setCreateTime(DateUtil.getDateTimeString((Date)passwdInfo.getCreateTime()));
                dto.setGroupId(passwdInfo.getGroupId());
                dto.setHostRemark(passwdInfo.getHostRemark());
                dto.setAccount(passwdInfo.getAccount());
                dto.setHostname(passwdInfo.getHostname());
                dto.setHostPasswd(passwdInfo.getHostPasswd());
                dto.setHostMark(passwdInfo.getHostMark());
                dto.setHostAccount(passwdInfo.getHostAccount());
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_\u8bbe\u5907\u8d26\u53f7";
            response.setContentType("application/vnd.ms-exce");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), PasswdInfoExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u5907\u8d26\u53f7\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportWorkInfoListExcel(List<WorkInfo> workInfoList, HttpServletResponse response) {
        HashMap<String, String> params = new HashMap<String, String>();
        Object out = null;
        try {
            ArrayList<WorkInfoExcelDto> excelList = new ArrayList<WorkInfoExcelDto>();
            for (WorkInfo workInfo : workInfoList) {
                WorkInfoExcelDto dto = new WorkInfoExcelDto();
                dto.setWorkCode(workInfo.getWorkCode() + "");
                dto.setCreateTime(DateUtil.getDateTimeString((Date)workInfo.getCreateTime()));
                dto.setUpdateTime(DateUtil.getDateTimeString((Date)workInfo.getUpdateTime()));
                dto.setGroupId(workInfo.getGroupId());
                dto.setWorkTitle(workInfo.getWorkTitle());
                dto.setAddAccountName(workInfo.getAddAccountName());
                dto.setAcceptAccountName(workInfo.getAcceptAccountName());
                dto.setState(this.workInfoService.getStateName(workInfo.getState()));
                CleanerProperties props = new CleanerProperties();
                props.setPruneTags("script");
                String result = new HtmlCleaner(props).clean(workInfo.getWorkContent()).getText().toString();
                dto.setWorkContent(result);
                dto.setWorkType(workInfo.getWorkType());
                params.put("workInfoId", workInfo.getId());
                List workFileInfoList = this.workFileInfoService.selectAllByParams(params);
                String workFileNames = "";
                for (WorkFileInfo workFileInfo : workFileInfoList) {
                    workFileNames = workFileNames + workFileInfo.getFileName() + ",";
                }
                dto.setWorkFileInfoList(workFileNames);
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_\u5de5\u5355\u5217\u8868";
            response.setContentType("application/vnd.ms-exce");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), WorkInfoExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u5de5\u5355\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

