/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.HostGroup;
import com.wgcloud.entity.PasswdInfo;
import com.wgcloud.mapper.PasswdInfoMapper;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class PasswdInfoService {
    @Autowired
    private PasswdInfoMapper passwdInfoMapper;
    @Autowired
    private LogInfoService logInfoService;
    @Resource
    private HostGroupService hostGroupService;

    public PageInfo<PasswdInfo> selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.passwdInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(PasswdInfo passwdInfo) throws Exception {
        passwdInfo.setId(UUIDUtil.getUUID());
        passwdInfo.setCreateTime(new Date());
        this.passwdInfoMapper.save(passwdInfo);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.passwdInfoMapper.deleteById(id);
    }

    public void updateById(PasswdInfo PasswdInfo2) throws Exception {
        this.passwdInfoMapper.updateById(PasswdInfo2);
    }

    public PasswdInfo selectById(String id) throws Exception {
        return this.passwdInfoMapper.selectById(id);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.passwdInfoMapper.countByParams(params);
    }

    public List<HostGroup> setGroupInList(List<PasswdInfo> recordList, Model model, HttpServletRequest request) throws Exception {
        HashMap params = new HashMap();
        List hostGroupList = this.hostGroupService.selectAllByParams(params, request);
        model.addAttribute("hostGroupList", (Object)hostGroupList);
        HashMap<String, String> hostGroupMap = new HashMap<String, String>();
        for (HostGroup hostGroup : hostGroupList) {
            hostGroupMap.put(hostGroup.getId(), hostGroup.getGroupName());
        }
        for (PasswdInfo appInfo : recordList) {
            if (StringUtils.isEmpty((CharSequence)appInfo.getGroupId())) continue;
            String groupNames = "";
            for (String groupId : appInfo.getGroupId().split(",")) {
                if (!hostGroupMap.containsKey(groupId)) continue;
                groupNames = groupNames + (String)hostGroupMap.get(groupId) + ",";
            }
            appInfo.setGroupId(groupNames);
        }
        return hostGroupList;
    }

    public void saveGroupId(String ids, String[] groupIdsArr, HttpServletRequest request) throws Exception {
        List hostGroupList = new ArrayList();
        if (null != groupIdsArr && groupIdsArr.length > 0) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("groupIds", groupIdsArr);
            hostGroupList = this.hostGroupService.selectAllByParams(params, request);
        }
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            PasswdInfo ho = null;
            for (String id : ids.split(",")) {
                ho = this.selectById(id);
                if (hostGroupList.size() > 0) {
                    ho.setGroupId(StringUtils.join((Object[])groupIdsArr, (String)","));
                } else {
                    ho.setGroupId("");
                }
                this.updateById(ho);
            }
        }
    }

    public void saveLog(HttpServletRequest request, String action, PasswdInfo passwdInfo) {
        if (null == passwdInfo) {
            return;
        }
        this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + action + "\u8bbe\u5907\u8d26\u53f7\uff1a" + passwdInfo.getHostname(), "\u8bbe\u5907\u8d26\u53f7\uff1a" + passwdInfo.getHostname(), "2");
    }

    public void updateToTargetAccount(Map<String, Object> params) throws Exception {
        this.passwdInfoMapper.updateToTargetAccount(params);
    }
}

