/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.WorkInfo;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;

public class WorkUtil {
    private static final Logger logger = LoggerFactory.getLogger(WorkUtil.class);

    public static String getRealName(String account) {
        String realName = account;
        try {
            if (null != StaticKeys.ACCOUNT_INFO_MAP.get(account)) {
                realName = ((AccountInfo)StaticKeys.ACCOUNT_INFO_MAP.get(account)).getRealName();
            }
            return realName;
        }
        catch (Exception e) {
            logger.error("getRealName\u9519\u8bef", (Throwable)e);
            return realName;
        }
    }

    public static void workDurationHandle(WorkInfo workInfo, Integer stepNum, Model model) {
        long millisPerHour = 3600000L;
        try {
            long timeDelay;
            String delayDayAndHourDiff;
            Date updateTime = workInfo.getUpdateTime();
            Date createTime = workInfo.getCreateTime();
            long timeDiff = updateTime.getTime() - createTime.getTime();
            String calculateDayAndHourDiff = FormatUtil.timesToDay((Long)(timeDiff / 1000L));
            StringBuilder msgForWork = new StringBuilder("\u63d0\u793a\uff1a\u8be5\u5de5\u5355");
            if (!StringUtils.isEmpty((CharSequence)calculateDayAndHourDiff)) {
                msgForWork.append("\u7d2f\u8ba1\u5904\u7406\u65f6\u957f\u3010" + calculateDayAndHourDiff + "\u3011\uff0c");
            }
            msgForWork.append("\u7d2f\u8ba1\u5904\u7406\u6b21\u6570\u3010" + stepNum + "\u6b21\u3011");
            if (("1".equals(workInfo.getState()) || "2".equals(workInfo.getState())) && !StringUtils.isEmpty((CharSequence)(delayDayAndHourDiff = FormatUtil.timesToDay((Long)((timeDelay = new Date().getTime() - updateTime.getTime()) / 1000L))))) {
                msgForWork.append("\uff0c\u81ea\u4e0a\u6b21\u5904\u7406\u540e\u6ede\u7559\u65f6\u957f\u3010" + delayDayAndHourDiff + "\u3011");
            }
            model.addAttribute("workInfoCalculateMsg", (Object)msgForWork.toString());
        }
        catch (Exception e) {
            logger.error(" \u8ba1\u7b97\u5de5\u5355\u7d2f\u8ba1\u5904\u7406\u65f6\u957f\u9519\u8bef", (Throwable)e);
        }
    }
}

