/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.ReportInfo;
import com.wgcloud.entity.ReportInstance;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.ReportInfoService;
import com.wgcloud.service.ReportInstanceService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/report"})
public class ReportController {
    private static final Logger logger = LoggerFactory.getLogger(ReportController.class);
    @Resource
    private ReportInfoService reportInfoService;
    @Autowired
    private ReportInstanceService reportInstanceService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private CommonConfig commonConfig;

    private void testThread() {
        Runnable runnable = () -> logger.info("ReportController----------testThread");
        ThreadPoolUtil.executor.execute(runnable);
    }

    @RequestMapping(value={"list"})
    public String reportInfoList(ReportInfo reportInfo, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            String checkTitle = request.getParameter("reportType");
            if (!StringUtils.isEmpty((CharSequence)reportInfo.getCheckTitle())) {
                checkTitle = reportInfo.getCheckTitle();
                params.put("checkTitle", checkTitle.trim());
                url.append("&checkTitle=").append(checkTitle);
            }
            if (!StringUtils.isEmpty((CharSequence)reportInfo.getAccount())) {
                params.put("account", reportInfo.getAccount());
                url.append("&account=").append(reportInfo.getAccount());
            }
            HostUtil.addAccountquery((HttpServletRequest)request, params);
            PageInfo pageInfo = this.reportInfoService.selectByParams(params, reportInfo.getPage().intValue(), reportInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/report/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("reportInfo", (Object)reportInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5de1\u68c0\u62a5\u544a\u5217\u8868\u9519\u8bef", (Throwable)e);
        }
        return "report/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u5de1\u68c0\u62a5\u544a\u4fe1\u606f";
        String id = request.getParameter("id");
        ReportInfo reportInfo = new ReportInfo();
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("xunjianIndex", (Object)0);
                reportInfo.setCheckDate(DateUtil.getCurrentDate());
                model.addAttribute("reportInfo", (Object)reportInfo);
                return "report/add";
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("reportInfoId", id);
            List reportInstanceList = this.reportInstanceService.selectAllByParams(params);
            model.addAttribute("xunjianList", (Object)reportInstanceList);
            if (!CollectionUtil.isEmpty((Collection)reportInstanceList)) {
                model.addAttribute("xunjianIndex", (Object)((ReportInstance)reportInstanceList.get(reportInstanceList.size() - 1)).getOrderNum());
            } else {
                model.addAttribute("xunjianIndex", (Object)0);
            }
            reportInfo = this.reportInfoService.selectById(id);
            model.addAttribute("reportInfo", (Object)reportInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "report/add";
    }

    @RequestMapping(value={"view"})
    public String viewReportInfo(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770b\u5de1\u68c0\u62a5\u544a\u4fe1\u606f";
        String id = request.getParameter("id");
        ReportInfo reportInfo = new ReportInfo();
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("xunjianIndex", (Object)0);
                reportInfo.setCheckDate(DateUtil.getCurrentDate());
                model.addAttribute("reportInfo", (Object)reportInfo);
                return "report/view";
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("reportInfoId", id);
            List reportInstanceList = this.reportInstanceService.selectAllByParams(params);
            model.addAttribute("xunjianList", (Object)reportInstanceList);
            if (!CollectionUtil.isEmpty((Collection)reportInstanceList)) {
                model.addAttribute("xunjianIndex", (Object)((ReportInstance)reportInstanceList.get(reportInstanceList.size() - 1)).getOrderNum());
            } else {
                model.addAttribute("xunjianIndex", (Object)0);
            }
            reportInfo = this.reportInfoService.selectById(id);
            model.addAttribute("reportInfo", (Object)reportInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "report/view";
    }

    @RequestMapping(value={"save"})
    public String saveReport(ReportInfo reportInfo, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)reportInfo.getId())) {
                AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
                if (null != accountInfo && !"admin".equals(accountInfo.getRole())) {
                    reportInfo.setAccount(accountInfo.getAccount());
                }
                this.reportInfoService.save(reportInfo, request);
            } else {
                this.reportInfoService.updateById(reportInfo, request);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de1\u68c0\u62a5\u544a\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u5de1\u68c0\u62a5\u544a\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/report/list";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664\u5de1\u68c0\u62a5\u544a\u9519\u8bef";
        ReportInfo reportInfo = new ReportInfo();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids = request.getParameter("id").split(",");
                this.reportInfoService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/report/list";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"chartExcel"})
    public void chartExcel(Model model, HttpServletRequest request, HttpServletResponse response) {
        Object out = null;
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
        }
        catch (Exception e) {
            logger.error("\u5de1\u68c0\u62a5\u544a\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

