/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.filter;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@WebFilter(filterName="authRestFilter", urlPatterns={"/*"})
public class AuthRestFilter
implements Filter {
    static Logger log = LoggerFactory.getLogger(AuthRestFilter.class);
    @Autowired
    CommonConfig commonConfig;
    String[] static_resource = new String[]{"/login/toLogin", "/login/login", "/static/", "/resources/", "/agentSubmitWorkInfo/save", "/vercode/get"};
    String[] guest_resource = new String[]{"/workInfoGuest/"};

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession();
        AccountInfo accountInfo = (AccountInfo)session.getAttribute("LOGIN_KEY");
        String uri = request.getRequestURI();
        log.debug("uri----" + uri);
        String servletPath = request.getServletPath();
        log.debug("servletPath----" + servletPath);
        for (String ss : this.static_resource) {
            if (!servletPath.startsWith(ss)) continue;
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        for (String ss : this.guest_resource) {
            if (!servletPath.startsWith(ss)) continue;
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        this.menuActive(session, uri, request);
        if (accountInfo != null && (servletPath.startsWith("/login/toLogin") || servletPath.equals("/") || servletPath.equals("/login/sso"))) {
            response.sendRedirect(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/dash/main");
            return;
        }
        if (accountInfo == null) {
            response.sendRedirect(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/login/toLogin");
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void menuActive(HttpSession session, String uri, HttpServletRequest request) {
        if (uri.endsWith(".js") || uri.endsWith(".css") || uri.endsWith(".mp3") || uri.endsWith(".png")) {
            return;
        }
        if (uri.indexOf("/dash/") > -1) {
            session.setAttribute("menuActive", (Object)"01");
            return;
        }
        if (uri.indexOf("/log/") > -1) {
            session.setAttribute("menuActive", (Object)"21");
            return;
        }
        if (uri.indexOf("/mailset") > -1) {
            session.setAttribute("menuActive", (Object)"71");
            return;
        }
        if (uri.indexOf("/warnScript") > -1) {
            session.setAttribute("menuActive", (Object)"81");
            return;
        }
        if (uri.indexOf("/hostGroup") > -1) {
            session.setAttribute("menuActive", (Object)"51");
            return;
        }
        if (uri.indexOf("/accountInfo") > -1) {
            session.setAttribute("menuActive", (Object)"61");
            return;
        }
        if (uri.indexOf("/passwdInfo") > -1) {
            session.setAttribute("menuActive", (Object)"31");
            return;
        }
        if (uri.indexOf("/equipment") > -1) {
            session.setAttribute("menuActive", (Object)"11");
            return;
        }
        if (uri.indexOf("/shellNoteInfo") > -1) {
            session.setAttribute("menuActive", (Object)"41");
            return;
        }
        if (uri.indexOf("/report") > -1) {
            session.setAttribute("menuActive", (Object)"91");
            return;
        }
        if (uri.indexOf("/ipUtilInfo") > -1) {
            session.setAttribute("menuActive", (Object)"w1");
            return;
        }
        session.setAttribute("menuActive", (Object)"01");
    }
}

