/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.Equipment;
import com.wgcloud.entity.EquipmentHandle;
import com.wgcloud.mapper.EquipmentHandleMapper;
import com.wgcloud.service.EquipmentService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EquipmentHandleService {
    private static final Logger logger = LoggerFactory.getLogger(EquipmentHandleService.class);
    @Autowired
    private EquipmentHandleMapper equipmentHandleMapper;
    @Autowired
    private EquipmentService equipmentService;
    @Autowired
    private LogInfoService logInfoService;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.equipmentHandleMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(EquipmentHandle equipmentHandle) throws Exception {
        equipmentHandle.setId(UUIDUtil.getUUID());
        equipmentHandle.setCreateTime((Date)DateUtil.getNowTime());
        this.equipmentHandleMapper.save(equipmentHandle);
    }

    public void commentWork(HttpServletRequest request) throws Exception {
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        String id = request.getParameter("id");
        String workContent = request.getParameter("workContent");
        if (!StringUtils.isEmpty((CharSequence)id) && !StringUtils.isEmpty((CharSequence)workContent)) {
            EquipmentHandle equipmentHandle = new EquipmentHandle();
            equipmentHandle.setAccountName(accountInfo.getRealName());
            equipmentHandle.setWorkContent(workContent);
            equipmentHandle.setEquipmentInfoId(id);
            this.save(equipmentHandle);
            this.saveLog(request, "\u6dfb\u52a0", equipmentHandle);
        }
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.equipmentHandleMapper.deleteById(id);
    }

    public void updateById(EquipmentHandle equipmentHandle) throws Exception {
        this.equipmentHandleMapper.updateById(equipmentHandle);
    }

    public EquipmentHandle selectById(String id) throws Exception {
        return this.equipmentHandleMapper.selectById(id);
    }

    public List<EquipmentHandle> selectByEquipmentId(String equipmentInfoId) throws Exception {
        return this.equipmentHandleMapper.selectByEquipmentId(equipmentInfoId);
    }

    public void checkDataAllowDel(List<EquipmentHandle> equipmentHandleList) {
        try {
            Date dateNow = new Date();
            for (EquipmentHandle handle : equipmentHandleList) {
                Long starTime = handle.getCreateTime().getTime();
                Long num = dateNow.getTime() - starTime;
                Long diffDays = num / 24L / 60L / 60L / 1000L;
                if (diffDays >= 30L) continue;
                handle.setAllowDel("1");
            }
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u8d44\u4ea7\u8bbe\u5907\u5904\u7406\u6570\u636e\u662f\u5426\u53ef\u4ee5\u5220\u9664\u9519\u8bef", (Throwable)e);
        }
    }

    public List<EquipmentHandle> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.equipmentHandleMapper.selectAllByParams(params);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.equipmentHandleMapper.countByParams(params);
    }

    public void diffEquipmentData(Equipment equipmentNew, Equipment equipmentOld, AccountInfo accountInfo) {
        String diffResult = "";
        try {
            if (null != equipmentNew && null != equipmentOld) {
                boolean result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getName(), (CharSequence)equipmentOld.getName());
                if (!result) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentName") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getName() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getName() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getCode(), (CharSequence)equipmentOld.getCode()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentCode") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getCode() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getCode() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getXinghao(), (CharSequence)equipmentOld.getXinghao()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentXinghao") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getXinghao() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getXinghao() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getDept(), (CharSequence)equipmentOld.getDept()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentDept") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getDept() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getDept() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getPerson(), (CharSequence)equipmentOld.getPerson()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentPerson") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getPerson() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getPerson() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getCaigouDate(), (CharSequence)equipmentOld.getCaigouDate()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentCaigouDate") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getCaigouDate() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getCaigouDate() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getGongyingshang(), (CharSequence)equipmentOld.getGongyingshang()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentGongyingshang") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getGongyingshang() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getGongyingshang() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getPrice(), (CharSequence)equipmentOld.getPrice()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentPrice") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getPrice() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getPrice() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getWeibaoDate(), (CharSequence)equipmentOld.getWeibaoDate()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentWeibaoDate") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getWeibaoDate() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getWeibaoDate() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equalsIgnoreCase((CharSequence)equipmentNew.getRemark(), (CharSequence)equipmentOld.getRemark()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentRemark") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getRemark() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getRemark() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equals((CharSequence)equipmentNew.getZiChanLeiBie(), (CharSequence)equipmentOld.getZiChanLeiBie()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("ziChanLeiBie") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getZiChanLeiBie() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getZiChanLeiBie() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equals((CharSequence)equipmentNew.getZiChanState(), (CharSequence)equipmentOld.getZiChanState()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("ziChanState") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getZiChanState() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getZiChanState() + "\u3011\uff0c";
                }
                if (!(result = StringUtils.equals((CharSequence)equipmentNew.getZiChanLocation(), (CharSequence)equipmentOld.getZiChanLocation()))) {
                    diffResult = diffResult + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("ziChanLocation") + "\u503c\u53d8\u5316\uff1a\u4fee\u6539\u540e\u3010" + equipmentNew.getZiChanLocation() + "\u3011\u4fee\u6539\u524d\u3010" + equipmentOld.getZiChanLocation() + "\u3011\uff0c";
                }
                if (!StringUtils.isEmpty((CharSequence)diffResult)) {
                    EquipmentHandle equipmentHandle = new EquipmentHandle();
                    equipmentHandle.setAccountName(accountInfo.getRealName());
                    equipmentHandle.setWorkContent("\u8d44\u4ea7\u4fe1\u606f\u53d8\u66f4\u8bb0\u5f55\uff0c" + diffResult);
                    equipmentHandle.setEquipmentInfoId(equipmentOld.getId());
                    this.save(equipmentHandle);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u4fe1\u606f\u53d8\u66f4\u8bb0\u5f55\u9519\u8bef", (Throwable)e);
        }
    }

    public void saveLog(HttpServletRequest request, String action, EquipmentHandle equipmentHandle) {
        if (null == equipmentHandle) {
            return;
        }
        try {
            Equipment equipment;
            String workContent = equipmentHandle.getWorkContent();
            if (!StringUtils.isEmpty((CharSequence)workContent) && workContent.length() > 50) {
                workContent = workContent.substring(0, 50);
            }
            if (null != (equipment = this.equipmentService.selectById(equipmentHandle.getEquipmentInfoId()))) {
                this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + action + "\u8d44\u4ea7\u5904\u7406\u4fe1\u606f\uff1a" + equipment.getName(), "\u8d44\u4ea7\u8bbe\u5907\u5904\u7406\u4fe1\u606f\uff1a" + equipment.getCode() + "\uff0c" + workContent, "2");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
    }
}

