/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.Equipment;
import com.wgcloud.entity.HostGroup;
import com.wgcloud.mapper.EquipmentMapper;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FileUtils;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PropertyUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EquipmentService {
    private static final Logger logger = LoggerFactory.getLogger(EquipmentService.class);
    @Autowired
    private EquipmentMapper equipmentMapper;
    @Autowired
    private LogInfoService logInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private CommonConfig commonConfig;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.equipmentMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(Equipment equipment) throws Exception {
        equipment.setId(UUIDUtil.getUUID());
        equipment.setCreateTime(new Date());
        this.equipmentMapper.save(equipment);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.equipmentMapper.deleteById(id);
    }

    public void updateById(Equipment equipment) throws Exception {
        this.equipmentMapper.updateById(equipment);
    }

    public Equipment selectById(String id) throws Exception {
        return this.equipmentMapper.selectById(id);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.equipmentMapper.countByParams(params);
    }

    public List<HostGroup> setGroupInList(List<Equipment> recordList, Model model, HttpServletRequest request) throws Exception {
        HashMap params = new HashMap();
        List hostGroupList = this.hostGroupService.selectAllByParams(params, request);
        model.addAttribute("hostGroupList", (Object)hostGroupList);
        HashMap<String, String> hostGroupMap = new HashMap<String, String>();
        for (HostGroup hostGroup : hostGroupList) {
            hostGroupMap.put(hostGroup.getId(), hostGroup.getGroupName());
        }
        for (Equipment appInfo : recordList) {
            if (StringUtils.isEmpty((CharSequence)appInfo.getGroupId())) continue;
            String groupNames = "";
            for (String groupId : appInfo.getGroupId().split(",")) {
                if (!hostGroupMap.containsKey(groupId)) continue;
                groupNames = groupNames + (String)hostGroupMap.get(groupId) + ",";
            }
            if (groupNames.endsWith(",")) {
                groupNames = groupNames.substring(0, groupNames.length() - 1);
            }
            appInfo.setGroupId(groupNames);
        }
        return hostGroupList;
    }

    public void saveGroupId(String ids, String[] groupIdsArr, HttpServletRequest request) throws Exception {
        List hostGroupList = new ArrayList();
        if (null != groupIdsArr && groupIdsArr.length > 0) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("groupIds", groupIdsArr);
            hostGroupList = this.hostGroupService.selectAllByParams(params, request);
        }
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            Equipment ho = null;
            for (String id : ids.split(",")) {
                ho = this.selectById(id);
                if (hostGroupList.size() > 0) {
                    ho.setGroupId(StringUtils.join((Object[])groupIdsArr, (String)","));
                } else {
                    ho.setGroupId("");
                }
                this.updateById(ho);
                this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + "\u8bbe\u7f6e\u8d44\u4ea7\u6807\u7b7e\uff1a" + ho.getName(), "\u6807\u7b7e\uff1a" + this.hostGroupService.returnGroupNames(hostGroupList), "2");
            }
        }
    }

    public void updateToTargetAccount(Map<String, Object> params) throws Exception {
        this.equipmentMapper.updateToTargetAccount(params);
    }

    public List<Equipment> groupByLeibie(Map<String, Object> params) throws Exception {
        return this.equipmentMapper.groupByLeibie(params);
    }

    public List<Equipment> groupByState(Map<String, Object> params) throws Exception {
        return this.equipmentMapper.groupByState(params);
    }

    public void saveLog(HttpServletRequest request, String action, Equipment equipment) {
        if (null == equipment) {
            return;
        }
        this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + action + "\u8d44\u4ea7\u8bbe\u5907\u4fe1\u606f\uff1a" + equipment.getName(), "\u8d44\u4ea7\u4fe1\u606f\uff1a" + equipment.getXinghao(), "2");
    }

    public void importExcelEquipment() {
        try {
            XSSFRow row;
            String filePath = StaticKeys.JAR_PATH + "/template/equipment.xlsx";
            if (!FileUtils.existsFile((String)filePath)) {
                return;
            }
            logger.info("\u5f00\u59cb\u4eceexcel\u6587\u4ef6\u5bfc\u5165\u8d44\u4ea7\u8bbe\u5907\u6570\u636e-----" + filePath);
            String[] workStateArr = this.commonConfig.getWorkState().split(",");
            String defaultLeibie = "\u4f7f\u7528\u4e2d";
            if (null != workStateArr && workStateArr.length > 0) {
                defaultLeibie = workStateArr[0];
            }
            XSSFWorkbook workbook = new XSSFWorkbook(filePath);
            XSSFSheet sheet = workbook.getSheetAt(0);
            int firstRowNum = sheet.getFirstRowNum();
            int lastRowNum = sheet.getLastRowNum();
            for (int rowNum = firstRowNum; rowNum <= lastRowNum && null != (row = sheet.getRow(rowNum)); ++rowNum) {
                if (null == row.getCell(0)) continue;
                String cellName = row.getCell(0).getStringCellValue();
                if (!StringUtils.isEmpty((CharSequence)cellName)) {
                    cellName = cellName.trim();
                }
                String cellCode = "";
                if (null != row.getCell(1)) {
                    if (row.getCell(1).getCellType() == CellType.STRING) {
                        cellCode = row.getCell(1).getStringCellValue();
                    }
                    if (row.getCell(1).getCellType() == CellType.NUMERIC) {
                        cellCode = row.getCell(1).getNumericCellValue() + "";
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)cellCode)) {
                    cellCode = cellCode.trim();
                }
                String cellXinghao = "";
                if (null != row.getCell(2)) {
                    cellXinghao = row.getCell(2).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellXinghao)) {
                    cellXinghao = cellXinghao.trim();
                }
                String cellDept = "";
                if (null != row.getCell(3)) {
                    cellDept = row.getCell(3).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellDept)) {
                    cellDept = cellDept.trim();
                }
                String cellPerson = "";
                if (null != row.getCell(4)) {
                    cellPerson = row.getCell(4).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellPerson)) {
                    cellPerson = cellPerson.trim();
                }
                String cellCaigouDate = "";
                if (null != row.getCell(5)) {
                    cellCaigouDate = row.getCell(5).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellCaigouDate)) {
                    cellCaigouDate = cellCaigouDate.trim();
                }
                String cellGongyingshang = "";
                if (null != row.getCell(6)) {
                    cellGongyingshang = row.getCell(6).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellGongyingshang)) {
                    cellGongyingshang = cellGongyingshang.trim();
                }
                String cellPrice = "0";
                if (null != row.getCell(7)) {
                    if (row.getCell(7).getCellType() == CellType.STRING) {
                        cellPrice = row.getCell(7).getStringCellValue();
                    }
                    if (row.getCell(7).getCellType() == CellType.NUMERIC) {
                        cellPrice = row.getCell(7).getNumericCellValue() + "";
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)cellPrice)) {
                    cellPrice = cellPrice.trim();
                }
                String cellWeibaoDate = "";
                if (null != row.getCell(8)) {
                    cellWeibaoDate = row.getCell(8).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellWeibaoDate)) {
                    cellWeibaoDate = cellWeibaoDate.trim();
                }
                String cellRemark = "";
                if (null != row.getCell(9)) {
                    cellRemark = row.getCell(9).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellRemark)) {
                    cellRemark = cellRemark.trim();
                }
                if (StringUtils.isEmpty((CharSequence)cellName)) continue;
                Equipment equipment = new Equipment();
                equipment.setName(cellName);
                equipment.setCode(cellCode);
                equipment.setXinghao(cellXinghao);
                equipment.setDept(cellDept);
                equipment.setPerson(cellPerson);
                equipment.setCaigouDate(cellCaigouDate);
                equipment.setGongyingshang(cellGongyingshang);
                equipment.setZiChanLeiBie("\u56fa\u5b9a\u8d44\u4ea7");
                equipment.setZiChanState(defaultLeibie);
                try {
                    equipment.setPrice(cellPrice);
                }
                catch (Exception e) {
                    logger.error("\u8d44\u4ea7\u8bbe\u5907\u5bfc\u5165excel\u9519\u8bef", (Throwable)e);
                }
                equipment.setWeibaoDate(cellWeibaoDate);
                equipment.setRemark(cellRemark);
                this.save(equipment);
            }
            File oldFile = new File(filePath);
            File newFile = new File(StaticKeys.JAR_PATH + "/template/equipment_" + DateUtil.getCurrentDateTimeNoChar() + ".xlsx");
            oldFile.renameTo(newFile);
            logger.info("\u5bfc\u5165\u8d44\u4ea7\u8bbe\u5907\u6570\u636e\u5b8c\u6210\uff0c\u4fee\u6539\u6587\u4ef6\u540d\u79f0\u4e3a-----" + newFile.getName());
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u8bbe\u5907\u5bfc\u5165excel\u9519\u8bef", (Throwable)e);
        }
    }

    public void saveAttachFile(MultipartFile file, Equipment equipment, HttpServletRequest request) {
        try {
            String equipmentAttachmentChange = request.getParameter("equipmentAttachmentChange");
            if ("del".equals(equipmentAttachmentChange)) {
                equipment.setFileName("");
                equipment.setFilePath("");
                equipment.setFileSize("");
            }
            String allowFileTypes = "jpg,jpeg,png,zip,log,tar.gz,doc,docx,ppt,pptx,xls,xlsx,pdf,txt,html";
            if (file.isEmpty()) {
                logger.error("\u4e0a\u4f20\u8d44\u4ea7\u8bbe\u5907\u9644\u4ef6\u4e3a\u7a7a");
                return;
            }
            String fileSize = FormatUtil.bytesFormatUnit((String)(file.getBytes().length + ""), (String)"byte");
            String sourceFileName = file.getOriginalFilename();
            if (StringUtils.isEmpty((CharSequence)sourceFileName)) {
                return;
            }
            String fileType = sourceFileName.substring(sourceFileName.lastIndexOf(".") + 1);
            if (!allowFileTypes.contains(fileType)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u8d44\u4ea7\u8bbe\u5907\u9644\u4ef6\u7c7b\u578b:" + sourceFileName);
                return;
            }
            String day = DateUtil.getCurrentDate().replace("-", "");
            String saveFolderUploadFile = StaticKeys.JAR_PATH + "/uploadFile";
            FileUtils.existsFolder((String)saveFolderUploadFile);
            String saveFolder = StaticKeys.JAR_PATH + "/uploadFile/" + day;
            FileUtils.existsFolder((String)saveFolder);
            String newFileName = DateUtil.getCurrentDateTimeNoChar() + FormatUtil.getRandInt() + "." + fileType;
            String newFilePath = saveFolder + "/" + newFileName;
            Path path = Paths.get(newFilePath, new String[0]);
            file.transferTo(path);
            equipment.setFileName(sourceFileName);
            equipment.setFilePath("/uploadFile/" + day + "/" + newFileName);
            equipment.setFileSize(fileSize);
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u8bbe\u5907\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef", (Throwable)e);
        }
    }

    public void setEquipmentColNames() {
        try {
            StaticKeys.EQUIPMENT_COLNAMES_MAP.clear();
            this.servletContext.setAttribute("equipmentName", (Object)"\u8d44\u4ea7\u540d\u79f0");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentName", "\u8d44\u4ea7\u540d\u79f0");
            this.servletContext.setAttribute("equipmentCode", (Object)"\u8d44\u4ea7\u7f16\u7801");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentCode", "\u8d44\u4ea7\u7f16\u7801");
            this.servletContext.setAttribute("equipmentXinghao", (Object)"\u89c4\u683c\u8bf4\u660e");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentXinghao", "\u89c4\u683c\u8bf4\u660e");
            this.servletContext.setAttribute("equipmentDept", (Object)"\u4f7f\u7528\u90e8\u95e8");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentDept", "\u4f7f\u7528\u90e8\u95e8");
            this.servletContext.setAttribute("equipmentPerson", (Object)"\u4f7f\u7528\u4eba\u5458");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentPerson", "\u4f7f\u7528\u4eba\u5458");
            this.servletContext.setAttribute("equipmentCaigouDate", (Object)"\u91c7\u8d2d\u65e5\u671f");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentCaigouDate", "\u91c7\u8d2d\u65e5\u671f");
            this.servletContext.setAttribute("equipmentGongyingshang", (Object)"\u4f9b\u5e94\u5546");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentGongyingshang", "\u4f9b\u5e94\u5546");
            this.servletContext.setAttribute("equipmentPrice", (Object)"\u91c7\u8d2d\u4ef7\u683c(\u5143)");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentPrice", "\u91c7\u8d2d\u4ef7\u683c(\u5143)");
            this.servletContext.setAttribute("equipmentWeibaoDate", (Object)"\u7ef4\u4fdd\u5230\u671f\u65f6\u95f4");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentWeibaoDate", "\u7ef4\u4fdd\u5230\u671f\u65f6\u95f4");
            this.servletContext.setAttribute("equipmentRemark", (Object)"\u5907\u6ce8");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("equipmentRemark", "\u5907\u6ce8");
            this.servletContext.setAttribute("ziChanLeiBie", (Object)"\u8d44\u4ea7\u7c7b\u522b");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("ziChanLeiBie", "\u8d44\u4ea7\u7c7b\u522b");
            this.servletContext.setAttribute("ziChanState", (Object)"\u8d44\u4ea7\u72b6\u6001");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("ziChanState", "\u8d44\u4ea7\u72b6\u6001");
            this.servletContext.setAttribute("ziChanLocation", (Object)"\u5b58\u653e\u4f4d\u7f6e");
            StaticKeys.EQUIPMENT_COLNAMES_MAP.put("ziChanLocation", "\u5b58\u653e\u4f4d\u7f6e");
            Map mapColNames = PropertyUtil.getKeys((String)(StaticKeys.JAR_PATH + "/config/equipmentDiy.properties"));
            if (null != mapColNames) {
                if (!StaticKeys.LICENSE_STATE.equals("1")) {
                    logger.info("\u5f53\u524d\u5df2\u4f7f\u7528\u7cfb\u7edf\u9ed8\u8ba4\u914d\u7f6e\u7684\u8d44\u4ea7\u5b57\u6bb5\u540d\u79f0");
                    return;
                }
                for (Map.Entry entry : mapColNames.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.servletContext.setAttribute(key, (Object)value);
                    StaticKeys.EQUIPMENT_COLNAMES_MAP.put(key, value);
                }
                logger.info("\u5f53\u524d\u5df2\u4f7f\u7528\u81ea\u5b9a\u4e49\u914d\u7f6e\u7684\u8d44\u4ea7\u5b57\u6bb5\u540d\u79f0");
            }
        }
        catch (Exception e) {
            logger.error("\u81ea\u5b9a\u4e49\u8bbe\u7f6e\u8d44\u4ea7\u8bbe\u5907\u7684\u5217\u540d\u79f0\u9519\u8bef", (Throwable)e);
        }
    }

    public void checkExpWeibaoDate() {
        try {
            HashMap paramsPasswd = new HashMap();
            List equipmentList = this.equipmentMapper.selectAllByParams(paramsPasswd);
            for (Equipment equipment : equipmentList) {
                String weibaoDate = equipment.getWeibaoDate();
                if (StringUtils.isEmpty((CharSequence)weibaoDate)) continue;
                Date weibaoDateFormat = null;
                try {
                    weibaoDateFormat = DateUtil.getDate((String)weibaoDate, (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    logger.error("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef", (Throwable)e);
                }
                Date nowDate = new Date();
                Long starTime = nowDate.getTime();
                Long endTime = weibaoDateFormat.getTime();
                Long num = endTime - starTime;
                Long days = num / 24L / 60L / 60L / 1000L;
                if (days > 30L) continue;
                Runnable runnable = () -> {
                    try {
                        String content = "\u8d44\u4ea7\u8bbe\u5907" + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentWeibaoDate") + "\u63d0\u9192\uff0c" + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentName") + ": " + equipment.getName() + "\uff0c" + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentCode") + ": " + equipment.getCode() + "\uff0c" + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentWeibaoDate") + ": " + weibaoDate;
                        WarnOtherUtil.sendUtil((String)("\u8d44\u4ea7\u8bbe\u5907" + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentWeibaoDate") + "\u63d0\u9192\uff1a" + equipment.getName() + "-" + weibaoDate), (String)content, (String)equipment.getAccount());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                };
                ThreadPoolUtil.executor.execute(runnable);
            }
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u8d44\u4ea7\u8bbe\u5907\u7684\u7ef4\u4fdd\u5230\u671f\u65f6\u95f4\u9519\u8bef", (Throwable)e);
        }
    }

    public String getQRCodeData(Equipment equipment) {
        if (null == equipment) {
            return "";
        }
        String result = "";
        if (!StringUtils.isEmpty((CharSequence)equipment.getName())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentName") + "\uff1a" + equipment.getName() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getZiChanLeiBie())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("ziChanLeiBie") + "\uff1a" + equipment.getZiChanLeiBie() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getZiChanState())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("ziChanState") + "\uff1a" + equipment.getZiChanState() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getCode())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentCode") + "\uff1a" + equipment.getCode() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getXinghao())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentXinghao") + "\uff1a" + equipment.getXinghao() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getDept())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentDept") + "\uff1a" + equipment.getDept() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getPerson())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentPerson") + "\uff1a" + equipment.getPerson() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getCaigouDate())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentCaigouDate") + "\uff1a" + equipment.getCaigouDate() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getGongyingshang())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentGongyingshang") + "\uff1a" + equipment.getGongyingshang() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getPrice())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentPrice") + "\uff1a" + equipment.getPrice() + "\uff0c";
        }
        if (!StringUtils.isEmpty((CharSequence)equipment.getWeibaoDate())) {
            result = result + (String)StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentWeibaoDate") + "\uff1a" + equipment.getWeibaoDate() + "\uff0c";
        }
        return result;
    }

    public String goLambdaFunc() {
        String[] str = new String[]{"a", "ba", "cc", "dd"};
        Arrays.sort(str, new /* Unavailable Anonymous Inner Class!! */);
        String[] str1 = new String[]{"a", "ba", "cc", "dd"};
        Arrays.sort(str1, (o1, o2) -> Integer.compare(o1.length(), o1.length()));
        return "";
    }
}

