/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.wgcloud.dto.EquipmentExcelDto;
import com.wgcloud.dto.IPInfoExcelDto;
import com.wgcloud.dto.PasswdInfoExcelDto;
import com.wgcloud.entity.Equipment;
import com.wgcloud.entity.IPUtilInfo;
import com.wgcloud.entity.PasswdInfo;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExcelExportService {
    private static final Logger logger = LoggerFactory.getLogger(ExcelExportService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportEquipmentListExcel(List<Equipment> equipmentList, HttpServletResponse response) {
        Object out = null;
        try {
            ArrayList<EquipmentExcelDto> excelList = new ArrayList<EquipmentExcelDto>();
            for (Equipment equipment : equipmentList) {
                EquipmentExcelDto dto = new EquipmentExcelDto();
                dto.setCreateTime(DateUtil.getDateTimeString((Date)equipment.getCreateTime()));
                dto.setGroupId(equipment.getGroupId());
                dto.setRemark(equipment.getRemark());
                dto.setAccount(equipment.getAccount());
                dto.setCode(equipment.getCode());
                dto.setCaigouDate(equipment.getCaigouDate());
                dto.setDept(equipment.getDept());
                dto.setGongyingshang(equipment.getGongyingshang());
                dto.setName(equipment.getName());
                dto.setPerson(equipment.getPerson());
                dto.setPrice(equipment.getPrice() + "");
                dto.setWeibaoDate(equipment.getWeibaoDate());
                dto.setXinghao(equipment.getXinghao());
                dto.setZiChanLeiBie(equipment.getZiChanLeiBie());
                dto.setZiChanState(equipment.getZiChanState());
                excelList.add(dto);
            }
            ArrayList headList = new ArrayList();
            ArrayList headerRow1 = new ArrayList();
            headerRow1.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentName"));
            headList.add(headerRow1);
            ArrayList headerRow2 = new ArrayList();
            headerRow2.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentCode"));
            headList.add(headerRow2);
            ArrayList headerRow3 = new ArrayList();
            headerRow3.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentXinghao"));
            headList.add(headerRow3);
            ArrayList headerRow4 = new ArrayList();
            headerRow4.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentDept"));
            headList.add(headerRow4);
            ArrayList headerRow5 = new ArrayList();
            headerRow5.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentPerson"));
            headList.add(headerRow5);
            ArrayList headerRow6 = new ArrayList();
            headerRow6.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentCaigouDate"));
            headList.add(headerRow6);
            ArrayList headerRow7 = new ArrayList();
            headerRow7.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentGongyingshang"));
            headList.add(headerRow7);
            ArrayList headerRow8 = new ArrayList();
            headerRow8.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentPrice"));
            headList.add(headerRow8);
            ArrayList headerRow9 = new ArrayList();
            headerRow9.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentWeibaoDate"));
            headList.add(headerRow9);
            ArrayList headerRow10 = new ArrayList();
            headerRow10.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("equipmentRemark"));
            headList.add(headerRow10);
            ArrayList<String> headerRow11 = new ArrayList<String>();
            headerRow11.add("\u6240\u5c5e\u8d26\u53f7");
            headList.add(headerRow11);
            ArrayList<String> headerRow12 = new ArrayList<String>();
            headerRow12.add("\u6807\u7b7e");
            headList.add(headerRow12);
            ArrayList headerRow13 = new ArrayList();
            headerRow13.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("ziChanLeiBie"));
            headList.add(headerRow13);
            ArrayList headerRow14 = new ArrayList();
            headerRow14.add(StaticKeys.EQUIPMENT_COLNAMES_MAP.get("ziChanState"));
            headList.add(headerRow14);
            ArrayList<String> headerRow15 = new ArrayList<String>();
            headerRow15.add("\u6dfb\u52a0\u65f6\u95f4");
            headList.add(headerRow15);
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_\u8d44\u4ea7\u5217\u8868";
            response.setContentType("application/vnd.ms-exce");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName + ".xlsx");
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), EquipmentExcelDto.class).head(headList)).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPasswdInfoListExcel(List<PasswdInfo> passwdInfoList, HttpServletResponse response) {
        Object out = null;
        try {
            ArrayList<PasswdInfoExcelDto> excelList = new ArrayList<PasswdInfoExcelDto>();
            for (PasswdInfo passwdInfo : passwdInfoList) {
                PasswdInfoExcelDto dto = new PasswdInfoExcelDto();
                dto.setCreateTime(DateUtil.getDateTimeString((Date)passwdInfo.getCreateTime()));
                dto.setGroupId(passwdInfo.getGroupId());
                dto.setHostRemark(passwdInfo.getHostRemark());
                dto.setAccount(passwdInfo.getAccount());
                dto.setHostname(passwdInfo.getHostname());
                dto.setHostPasswd(passwdInfo.getHostPasswd());
                dto.setHostMark(passwdInfo.getHostMark());
                dto.setHostAccount(passwdInfo.getHostAccount());
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_\u8bbe\u5907\u8d26\u53f7\u5217\u8868";
            response.setContentType("application/vnd.ms-exce");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), PasswdInfoExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u5907\u8d26\u53f7\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportIPUtilInfoListExcel(List<IPUtilInfo> ipUtilInfoList, HttpServletResponse response) {
        Object out = null;
        try {
            ArrayList<IPInfoExcelDto> excelList = new ArrayList<IPInfoExcelDto>();
            for (IPUtilInfo ipUtilInfo : ipUtilInfoList) {
                IPInfoExcelDto dto = new IPInfoExcelDto();
                dto.setCreateTime(DateUtil.getDateTimeString((Date)ipUtilInfo.getCreateTime()));
                dto.setGroupId(ipUtilInfo.getGroupId());
                dto.setIpAddress(ipUtilInfo.getIpAddress());
                dto.setIpMac(ipUtilInfo.getIpMac());
                dto.setIpRemark(ipUtilInfo.getIpRemark());
                dto.setAccount(ipUtilInfo.getAccount());
                if ("1".equals(ipUtilInfo.getIpState())) {
                    dto.setIpState("\u4f7f\u7528\u4e2d");
                } else {
                    dto.setIpState("\u672a\u4f7f\u7528");
                }
                excelList.add(dto);
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar() + "_IP\u5217\u8868";
            response.setContentType("application/vnd.ms-exce");
            response.setCharacterEncoding("utf-8");
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "filename=" + encodedFileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), IPInfoExcelDto.class).sheet("sheet").doWrite(excelList);
        }
        catch (Exception e) {
            logger.error("IP\u5730\u5740\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

