/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.agentController;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.Equipment;
import com.wgcloud.entity.EquipmentExt;
import com.wgcloud.entity.EquipmentHandle;
import com.wgcloud.service.EquipmentExtService;
import com.wgcloud.service.EquipmentHandleService;
import com.wgcloud.service.EquipmentService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.UUIDUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/agentEquipmentInfo"})
public class AgentEquipmentController {
    private static final Logger logger = LoggerFactory.getLogger(AgentEquipmentController.class);
    @Resource
    private HostGroupService hostGroupService;
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;
    @Resource
    private EquipmentService equipmentService;
    @Resource
    private EquipmentHandleService equipmentHandleService;
    @Resource
    private EquipmentExtService equipmentExtService;

    @ResponseBody
    @RequestMapping(value={"/save"})
    public String save(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            logger.error("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u9519\u8bef: " + checkResult);
            return checkResult;
        }
        logger.debug("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u65b0\u589e\u8d44\u4ea7\u8bbe\u5907\u6570\u636e-------------" + agentJsonObject.toString());
        Equipment equipment = new Equipment();
        try {
            if (null != agentJsonObject.get((Object)"openId")) {
                equipment.setOpenId(agentJsonObject.getStr((Object)"openId"));
            }
            if (null != agentJsonObject.get((Object)"name")) {
                equipment.setName(agentJsonObject.getStr((Object)"name"));
            }
            if (null != agentJsonObject.get((Object)"xinghao")) {
                equipment.setXinghao(agentJsonObject.getStr((Object)"xinghao"));
            }
            if (null != agentJsonObject.get((Object)"person")) {
                equipment.setPerson(agentJsonObject.getStr((Object)"person"));
            }
            if (null != agentJsonObject.get((Object)"dept")) {
                equipment.setDept(agentJsonObject.getStr((Object)"dept"));
            }
            if (null != agentJsonObject.get((Object)"code")) {
                equipment.setCode(agentJsonObject.getStr((Object)"code"));
            }
            if (null != agentJsonObject.get((Object)"gongyingshang")) {
                equipment.setGongyingshang(agentJsonObject.getStr((Object)"gongyingshang"));
            }
            if (null != agentJsonObject.get((Object)"price")) {
                equipment.setPrice(agentJsonObject.getStr((Object)"price"));
            }
            if (null != agentJsonObject.get((Object)"caigouDate")) {
                equipment.setCaigouDate(agentJsonObject.getStr((Object)"caigouDate"));
            }
            if (null != agentJsonObject.get((Object)"remark")) {
                equipment.setRemark(agentJsonObject.getStr((Object)"remark"));
            }
            if (null != agentJsonObject.get((Object)"weibaoDate")) {
                equipment.setWeibaoDate(agentJsonObject.getStr((Object)"weibaoDate"));
            }
            if (null != agentJsonObject.get((Object)"account")) {
                equipment.setAccount(agentJsonObject.getStr((Object)"account"));
            }
            if (null != agentJsonObject.get((Object)"groupId")) {
                equipment.setGroupId(agentJsonObject.getStr((Object)"groupId"));
            }
            if (null != agentJsonObject.get((Object)"ziChanLeiBie")) {
                equipment.setZiChanLeiBie(agentJsonObject.getStr((Object)"ziChanLeiBie"));
            }
            if (null != agentJsonObject.get((Object)"ziChanState")) {
                equipment.setZiChanState(agentJsonObject.getStr((Object)"ziChanState"));
            }
            if (null != agentJsonObject.get((Object)"ziChanLocation")) {
                equipment.setZiChanLocation(agentJsonObject.getStr((Object)"ziChanLocation"));
            }
            this.equipmentService.save(equipment);
            this.saveEquipmentExtData(equipment.getId(), agentJsonObject, false);
            EquipmentHandle equipmentHandle = new EquipmentHandle();
            equipmentHandle.setAccountName("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u65b0\u589e");
            equipmentHandle.setWorkContent("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u65b0\u589e\u8d44\u4ea7\u8bbe\u5907\u6570\u636e");
            equipmentHandle.setEquipmentInfoId(equipment.getId());
            this.equipmentHandleService.save(equipmentHandle);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6570\u636e\u5f00\u653e\u63a5\u53e3\u65b0\u589e\u8d44\u4ea7\u8bbe\u5907\u6570\u636e\u9519\u8bef", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
        return ResDataUtils.resetSuccessJson((Object)equipment.getOpenId());
    }

    @ResponseBody
    @RequestMapping(value={"/updateByOpenId"})
    public String updateByOpenId(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            logger.error("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u9519\u8bef: " + checkResult);
            return checkResult;
        }
        if (null == agentJsonObject.getStr((Object)"openId")) {
            return ResDataUtils.resetErrorJson((String)"Missing require parameters");
        }
        logger.debug("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u66f4\u65b0\u8d44\u4ea7\u8bbe\u5907\u6570\u636e-------------" + agentJsonObject.toString());
        Equipment equipment = new Equipment();
        try {
            if (null != agentJsonObject.get((Object)"openId")) {
                equipment.setOpenId(agentJsonObject.getStr((Object)"openId"));
            }
            String openId = agentJsonObject.getStr((Object)"openId");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("openId", openId);
            List equipmentList = this.equipmentService.selectAllByParams(params);
            Equipment equipmentOld = new Equipment();
            if (equipmentList.size() <= 0) {
                return ResDataUtils.resetErrorJson((String)"Data not find");
            }
            equipment.setId(((Equipment)equipmentList.get(0)).getId());
            equipmentOld = (Equipment)equipmentList.get(0);
            if (null != agentJsonObject.get((Object)"name")) {
                equipment.setName(agentJsonObject.getStr((Object)"name"));
            }
            if (null != agentJsonObject.get((Object)"xinghao")) {
                equipment.setXinghao(agentJsonObject.getStr((Object)"xinghao"));
            }
            if (null != agentJsonObject.get((Object)"person")) {
                equipment.setPerson(agentJsonObject.getStr((Object)"person"));
            }
            if (null != agentJsonObject.get((Object)"dept")) {
                equipment.setDept(agentJsonObject.getStr((Object)"dept"));
            }
            if (null != agentJsonObject.get((Object)"code")) {
                equipment.setCode(agentJsonObject.getStr((Object)"code"));
            }
            if (null != agentJsonObject.get((Object)"gongyingshang")) {
                equipment.setGongyingshang(agentJsonObject.getStr((Object)"gongyingshang"));
            }
            if (null != agentJsonObject.get((Object)"price")) {
                equipment.setPrice(agentJsonObject.getStr((Object)"price"));
            }
            if (null != agentJsonObject.get((Object)"caigouDate")) {
                equipment.setCaigouDate(agentJsonObject.getStr((Object)"caigouDate"));
            }
            if (null != agentJsonObject.get((Object)"remark")) {
                equipment.setRemark(agentJsonObject.getStr((Object)"remark"));
            }
            if (null != agentJsonObject.get((Object)"weibaoDate")) {
                equipment.setWeibaoDate(agentJsonObject.getStr((Object)"weibaoDate"));
            }
            if (null != agentJsonObject.get((Object)"account")) {
                equipment.setAccount(agentJsonObject.getStr((Object)"account"));
            }
            if (null != agentJsonObject.get((Object)"groupId")) {
                equipment.setGroupId(agentJsonObject.getStr((Object)"groupId"));
            }
            if (null != agentJsonObject.get((Object)"ziChanLeiBie")) {
                equipment.setZiChanLeiBie(agentJsonObject.getStr((Object)"ziChanLeiBie"));
            }
            if (null != agentJsonObject.get((Object)"ziChanState")) {
                equipment.setZiChanState(agentJsonObject.getStr((Object)"ziChanState"));
            }
            if (null != agentJsonObject.get((Object)"ziChanLocation")) {
                equipment.setZiChanLocation(agentJsonObject.getStr((Object)"ziChanLocation"));
            }
            this.equipmentService.updateById(equipment);
            EquipmentExt equipmentExt = this.saveEquipmentExtData(equipment.getId(), agentJsonObject, true);
            if (null != equipmentExt) {
                this.equipmentExtService.updateByEquipmentId(equipmentExt);
            }
            EquipmentHandle equipmentHandle = new EquipmentHandle();
            equipmentHandle.setAccountName("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u4fee\u6539\u6570\u636e");
            equipmentHandle.setWorkContent("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u4fee\u6539\u8d44\u4ea7\u8bbe\u5907\u6570\u636e");
            equipmentHandle.setEquipmentInfoId(equipment.getId());
            this.equipmentHandleService.save(equipmentHandle);
            Equipment finalEquipmentOld = equipmentOld;
            Runnable runnable = () -> {
                AccountInfo accountInfo = new AccountInfo();
                accountInfo.setRealName("\u6570\u636e\u5f00\u653e\u63a5\u53e3");
                this.equipmentHandleService.diffEquipmentData(equipment, finalEquipmentOld, accountInfo);
            };
            ThreadPoolUtil.executor.execute(runnable);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6570\u636e\u5f00\u653e\u63a5\u53e3\u4fee\u6539\u8d44\u4ea7\u8bbe\u5907\u6570\u636e\u9519\u8bef", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
        return ResDataUtils.resetSuccessJson((Object)equipment.getOpenId());
    }

    @ResponseBody
    @RequestMapping(value={"agentList"})
    public String agentList(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            logger.error("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u9519\u8bef: " + checkResult);
            return checkResult;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (null == agentJsonObject.getInt((Object)"page") || null == agentJsonObject.getInt((Object)"pageSize")) {
            return ResDataUtils.resetErrorJson((String)"Missing require parameters");
        }
        if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"name"))) {
            params.put("name", agentJsonObject.get((Object)"name").toString());
        }
        if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"account"))) {
            params.put("account", agentJsonObject.get((Object)"account").toString());
        }
        if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"groupId"))) {
            params.put("groupId", agentJsonObject.get((Object)"groupId").toString());
        }
        if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"ziChanLeiBie"))) {
            params.put("ziChanLeiBie", agentJsonObject.getStr((Object)"ziChanLeiBie"));
        }
        if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"ziChanState"))) {
            params.put("ziChanState", agentJsonObject.getStr((Object)"ziChanState"));
        }
        if (!StringUtils.isEmpty((CharSequence)agentJsonObject.getStr((Object)"openId"))) {
            params.put("openId", agentJsonObject.getStr((Object)"openId"));
        }
        try {
            PageInfo pageInfo = this.equipmentService.selectByParams(params, agentJsonObject.getInt((Object)"page").intValue(), agentJsonObject.getInt((Object)"pageSize").intValue());
            ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
            for (Object object : pageInfo.getList()) {
                JSONObject jsonObject = JSONUtil.parseObj(object);
                Equipment equipment = (Equipment)object;
                List equipmentExtList = this.equipmentExtService.selectByEquipmentId(equipment.getId());
                if (equipmentExtList.size() > 0) {
                    EquipmentExt equipmentExt = (EquipmentExt)equipmentExtList.get(0);
                    JSONObject jsonObjectExt = JSONUtil.parseObj((Object)equipmentExt);
                    jsonObject.putAll((Map)jsonObjectExt);
                }
                jsonObjectList.add(jsonObject);
            }
            pageInfo.setList(jsonObjectList);
            return ResDataUtils.resetSuccessJson((Object)pageInfo);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u67e5\u8be2\u5217\u8868\u9519\u8bef", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
    }

    @ResponseBody
    @RequestMapping(value={"deleteByOpenId"})
    public String deleteByOpenId(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            logger.error("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u9519\u8bef: " + checkResult);
            return checkResult;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (null == agentJsonObject.getStr((Object)"openId")) {
            return ResDataUtils.resetErrorJson((String)"Missing require parameters");
        }
        try {
            String openId = agentJsonObject.getStr((Object)"openId");
            params.put("openId", openId);
            List equipmentList = this.equipmentService.selectAllByParams(params);
            if (equipmentList.size() <= 0) {
                return ResDataUtils.resetErrorJson((String)"Data not find");
            }
            Equipment equipment = (Equipment)equipmentList.get(0);
            this.equipmentService.deleteById(equipment.getId().split(","));
            this.equipmentExtService.deleteByEquipmentId(equipment.getId().split(","));
            this.logInfoService.save("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u5220\u9664\u8d44\u4ea7\u8bbe\u5907\u4fe1\u606f\uff1a" + equipment.getOpenId(), "\u8d44\u4ea7\u4fe1\u606f\uff1a" + equipment.getName() + "\uff0c" + equipment.getXinghao(), "2");
            return ResDataUtils.resetSuccessJson(null);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u5220\u9664\u6570\u636e\u9519\u8bef", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
    }

    @ResponseBody
    @RequestMapping(value={"getEquipmentQRCode"})
    public String getEquipmentQRCode(@RequestBody String paramBean, HttpServletResponse response) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            logger.error("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u9519\u8bef: " + checkResult);
            return checkResult;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String id = agentJsonObject.getStr((Object)"id");
        String openId = agentJsonObject.getStr((Object)"openId");
        if (StringUtils.isEmpty((CharSequence)"openId") && StringUtils.isEmpty((CharSequence)"id")) {
            return ResDataUtils.resetErrorJson((String)"Missing require parameters");
        }
        try {
            if (StringUtils.isEmpty((CharSequence)"id")) {
                params.put("openId", openId);
                List equipmentList = this.equipmentService.selectAllByParams(params);
                String equipmentId = "";
                if (equipmentList.size() > 0) {
                    Equipment equipment = (Equipment)equipmentList.get(0);
                    id = equipmentId;
                } else {
                    return ResDataUtils.resetErrorJson((String)"Data not find");
                }
            }
            HashMap<EncodeHintType, Object> map = new HashMap<EncodeHintType, Object>();
            map.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            map.put(EncodeHintType.CHARACTER_SET, "utf-8");
            map.put(EncodeHintType.MARGIN, 1);
            Equipment equipment = this.equipmentService.selectById(id);
            if (null == equipment) {
                return ResDataUtils.resetErrorJson((String)"Data not find");
            }
            String data = this.equipmentService.getQRCodeData(equipment);
            MultiFormatWriter writer = new MultiFormatWriter();
            BitMatrix bitMatrix = writer.encode(data, BarcodeFormat.QR_CODE, 275, 275, map);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            ImageIO.write((RenderedImage)image, "png", (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u8d44\u4ea7\u8bbe\u5907\u4e8c\u7ef4\u7801\u9519\u8bef", (Throwable)e);
        }
        return "";
    }

    @ResponseBody
    @RequestMapping(value={"agentHostGroupList"})
    public String agentHostGroupList(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            logger.error("\u6570\u636e\u5f00\u653e\u63a5\u53e3\u9519\u8bef: " + checkResult);
            return checkResult;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (null != agentJsonObject.get((Object)"groupName")) {
            params.put("groupName", agentJsonObject.get((Object)"groupName").toString());
        }
        try {
            List hostGroups = this.hostGroupService.selectAllByParams(params, null);
            return ResDataUtils.resetSuccessJson((Object)hostGroups);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u63a5\u53e3\u67e5\u8be2\u6807\u7b7e\u5217\u8868\u9519\u8bef", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
    }

    private EquipmentExt saveEquipmentExtData(String equipmentInfoId, JSONObject agentJsonObject, boolean ifUpdate) {
        try {
            if (StringUtils.isEmpty((CharSequence)equipmentInfoId)) {
                return null;
            }
            EquipmentExt equipmentExt = new EquipmentExt();
            if (!ifUpdate) {
                equipmentExt.setId(UUIDUtil.getUUID());
            }
            equipmentExt.setEquipmentInfoId(equipmentInfoId);
            if (null != agentJsonObject.get((Object)"equipmentF0")) {
                equipmentExt.setEquipmentF0(agentJsonObject.getStr((Object)"equipmentF0"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF1")) {
                equipmentExt.setEquipmentF1(agentJsonObject.getStr((Object)"equipmentF1"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF2")) {
                equipmentExt.setEquipmentF2(agentJsonObject.getStr((Object)"equipmentF2"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF3")) {
                equipmentExt.setEquipmentF3(agentJsonObject.getStr((Object)"equipmentF3"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF4")) {
                equipmentExt.setEquipmentF4(agentJsonObject.getStr((Object)"equipmentF4"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF5")) {
                equipmentExt.setEquipmentF5(agentJsonObject.getStr((Object)"equipmentF5"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF6")) {
                equipmentExt.setEquipmentF6(agentJsonObject.getStr((Object)"equipmentF6"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF7")) {
                equipmentExt.setEquipmentF7(agentJsonObject.getStr((Object)"equipmentF7"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF8")) {
                equipmentExt.setEquipmentF8(agentJsonObject.getStr((Object)"equipmentF8"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF9")) {
                equipmentExt.setEquipmentF9(agentJsonObject.getStr((Object)"equipmentF9"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF10")) {
                equipmentExt.setEquipmentF10(agentJsonObject.getStr((Object)"equipmentF10"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF11")) {
                equipmentExt.setEquipmentF11(agentJsonObject.getStr((Object)"equipmentF11"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF12")) {
                equipmentExt.setEquipmentF12(agentJsonObject.getStr((Object)"equipmentF12"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF12")) {
                equipmentExt.setEquipmentF12(agentJsonObject.getStr((Object)"equipmentF12"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF13")) {
                equipmentExt.setEquipmentF13(agentJsonObject.getStr((Object)"equipmentF13"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF14")) {
                equipmentExt.setEquipmentF14(agentJsonObject.getStr((Object)"equipmentF14"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF15")) {
                equipmentExt.setEquipmentF15(agentJsonObject.getStr((Object)"equipmentF15"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF16")) {
                equipmentExt.setEquipmentF16(agentJsonObject.getStr((Object)"equipmentF16"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF17")) {
                equipmentExt.setEquipmentF17(agentJsonObject.getStr((Object)"equipmentF17"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF18")) {
                equipmentExt.setEquipmentF18(agentJsonObject.getStr((Object)"equipmentF18"));
            }
            if (null != agentJsonObject.get((Object)"equipmentF19")) {
                equipmentExt.setEquipmentF19(agentJsonObject.getStr((Object)"equipmentF19"));
            }
            equipmentExt.setCreateTime(new Date());
            if (!ifUpdate) {
                this.equipmentExtService.save(equipmentExt);
            }
            return equipmentExt;
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u8d44\u4ea7\u8bbe\u5907\u4ece\u8868\u6570\u636e\u9519\u8bef", (Throwable)e);
            return null;
        }
    }
}

