/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.EquipmentService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.PasswdInfoService;
import com.wgcloud.service.ReportInfoService;
import com.wgcloud.service.ShellNoteInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.license.LicenseUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/dash"})
public class DashboardController {
    private static final Logger logger = LoggerFactory.getLogger(DashboardController.class);
    @Resource
    private EquipmentService equipmentService;
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Resource
    private PasswdInfoService passwdInfoService;
    @Resource
    private ShellNoteInfoService shellNoteInfoService;
    @Resource
    private ReportInfoService reportInfoService;
    @Resource
    private DashboardService dashboardService;
    @Autowired
    CommonConfig commonConfig;

    private void testThread() {
        Runnable runnable = () -> logger.info("DashboardCotroller----------testThread");
        ThreadPoolUtil.executor.execute(runnable);
    }

    @RequestMapping(value={"main"})
    public String mainList(Model model, HttpServletRequest request) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
            if (!"admin".equals(accountInfo.getRole())) {
                params.put("account", accountInfo.getAccount());
            }
            Integer countEquipment = this.equipmentService.countByParams(params);
            model.addAttribute("countEquipment", (Object)countEquipment);
            Integer countPasswd = this.passwdInfoService.countByParams(params);
            model.addAttribute("countPasswd", (Object)countPasswd);
            Integer countReportInfo = this.reportInfoService.countByParams(params);
            model.addAttribute("countReportInfo", (Object)countReportInfo);
            Integer countShellNote = this.shellNoteInfoService.countByParams(params);
            model.addAttribute("countShellNote", (Object)countShellNote);
            this.dashboardService.setIndexBar(model, request);
            model.addAttribute("pwdExpDateShow", (Object)this.commonConfig.getPwdExpDate());
            Integer accountNum = this.accountInfoService.countByParams(new HashMap());
            LicenseUtil.outDateAlter((Model)model, (int)accountNum);
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u6982\u8981\u9875\u9762\u4fe1\u606f\u5c55\u793a\u9519\u8bef", (Throwable)e);
        }
        return "index";
    }
}

