/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.Equipment;
import com.wgcloud.entity.EquipmentHandle;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.EquipmentExtService;
import com.wgcloud.service.EquipmentHandleService;
import com.wgcloud.service.EquipmentService;
import com.wgcloud.service.ExcelExportService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/equipment"})
public class EquipmentController {
    private static final Logger logger = LoggerFactory.getLogger(EquipmentController.class);
    @Resource
    private EquipmentService equipmentService;
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private ExcelExportService excelExportService;
    @Resource
    private EquipmentHandleService equipmentHandleService;
    @Resource
    private EquipmentExtService equipmentExtService;
    @Resource
    private HostGroupService hostGroupService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String equipmentList(Equipment equipment, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)equipment.getName())) {
                hostname = equipment.getName();
                params.put("name", hostname.trim());
                url.append("&name=").append(hostname);
            }
            if (!StringUtils.isEmpty((CharSequence)equipment.getAccount())) {
                params.put("account", equipment.getAccount());
                url.append("&account=").append(equipment.getAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)equipment.getGroupId())) {
                params.put("groupId", equipment.getGroupId());
                url.append("&groupId=").append(equipment.getGroupId());
            }
            if (!StringUtils.isEmpty((CharSequence)equipment.getZiChanLeiBie())) {
                params.put("ziChanLeiBie", equipment.getZiChanLeiBie());
                url.append("&ziChanLeiBie=").append(equipment.getZiChanLeiBie());
            }
            if (!StringUtils.isEmpty((CharSequence)equipment.getZiChanState())) {
                params.put("ziChanState", equipment.getZiChanState());
                url.append("&ziChanState=").append(equipment.getZiChanState());
            }
            HostUtil.addAccountquery((HttpServletRequest)request, params);
            PageInfo pageInfo = this.equipmentService.selectByParams(params, equipment.getPage().intValue(), equipment.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                this.equipmentService.setGroupInList(pageInfo.getList(), model, request);
            }
            HostUtil.addAccountListModel((Model)model);
            String[] workStateArr = this.commonConfig.getWorkState().split(",");
            model.addAttribute("workStateList", (Object)workStateArr);
            model.addAttribute("pageUrl", (Object)("/equipment/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("equipment", (Object)equipment);
            if (null == request.getSession().getAttribute("EquipmentListHideColsInfo")) {
                request.getSession().setAttribute("EquipmentListHideColsInfo", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8d44\u4ea7\u8bbe\u5907\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u8d44\u4ea7\u8bbe\u5907\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "equipment/list";
    }

    @RequestMapping(value={"save"})
    public String saveEquipment(@RequestParam(value="file") MultipartFile file, Equipment equipment, Model model, HttpServletRequest request) {
        try {
            AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
            if (StringUtils.isEmpty((CharSequence)equipment.getId())) {
                if (null != accountInfo && !"admin".equals(accountInfo.getRole())) {
                    equipment.setAccount(accountInfo.getAccount());
                }
                this.equipmentService.saveAttachFile(file, equipment, request);
                this.equipmentService.save(equipment);
                this.equipmentService.saveLog(request, "\u6dfb\u52a0", equipment);
                EquipmentHandle equipmentHandle = new EquipmentHandle();
                equipmentHandle.setAccountName(accountInfo.getRealName());
                equipmentHandle.setWorkContent("\u65b0\u589e\u8d44\u4ea7\u8bbe\u5907\u6570\u636e");
                equipmentHandle.setEquipmentInfoId(equipment.getId());
                this.equipmentHandleService.save(equipmentHandle);
                this.equipmentExtService.saveFormData(equipment.getId(), request);
            } else {
                this.equipmentService.saveAttachFile(file, equipment, request);
                Equipment equipmentOld = this.equipmentService.selectById(equipment.getId());
                this.equipmentService.updateById(equipment);
                this.equipmentService.saveLog(request, "\u4fee\u6539", equipment);
                Runnable runnable = () -> this.equipmentHandleService.diffEquipmentData(equipment, equipmentOld, accountInfo);
                ThreadPoolUtil.executor.execute(runnable);
                this.equipmentExtService.saveFormData(equipment.getId(), request);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u8d44\u4ea7\u8bbe\u5907\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u8d44\u4ea7\u8bbe\u5907\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/equipment/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u8d44\u4ea7\u8bbe\u5907";
        String id = request.getParameter("id");
        Equipment equipment = new Equipment();
        try {
            String[] workStateArr = this.commonConfig.getWorkState().split(",");
            model.addAttribute("workStateList", (Object)workStateArr);
            this.equipmentExtService.setExtValueHandle(id, model);
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("equipment", (Object)equipment);
                return "equipment/add";
            }
            equipment = this.equipmentService.selectById(id);
            model.addAttribute("equipment", (Object)equipment);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "equipment/add";
    }

    @RequestMapping(value={"copyEquipment"})
    public String copyEquipment(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u8d44\u4ea7\u8bbe\u5907";
        String id = request.getParameter("id");
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                return "redirect:/equipment/list";
            }
            Equipment equipment = this.equipmentService.selectById(id);
            equipment.setId(null);
            equipment.setName(equipment.getName() + "_1");
            this.equipmentService.save(equipment);
            this.equipmentService.saveLog(request, "\u6dfb\u52a0", equipment);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/equipment/list";
    }

    @ResponseBody
    @RequestMapping(value={"saveGroupId"})
    public String saveGroupId(Model model, HttpServletRequest request) {
        try {
            String ids = request.getParameter("ids");
            String[] groupIdsArr = request.getParameterValues("groupId");
            this.equipmentService.saveGroupId(ids, groupIdsArr, request);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u8d44\u4ea7\u8bbe\u5907\u6807\u7b7e\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u8d44\u4ea7\u8bbe\u5907\u6807\u7b7e\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/equipment/list";
    }

    @RequestMapping(value={"view"})
    public String viewChart(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770b\u8d44\u4ea7\u4fe1\u606f\u9519\u8bef";
        String id = request.getParameter("id");
        Equipment equipment = new Equipment();
        try {
            equipment = this.equipmentService.selectById(id);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                equipment.setGroupId(this.hostGroupService.returnGroupNames(equipment.getGroupId()));
            }
            model.addAttribute("equipment", (Object)equipment);
            List equipmentHandleList = this.equipmentHandleService.selectByEquipmentId(equipment.getId());
            this.equipmentHandleService.checkDataAllowDel(equipmentHandleList);
            model.addAttribute("equipmentHandleList", (Object)equipmentHandleList);
            this.equipmentExtService.setExtValueHandle(id, model);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "equipment/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request) {
        String errorMsg = "\u5220\u9664\u8d44\u4ea7\u8bbe\u5907\u4fe1\u606f\u9519\u8bef";
        Equipment equipment = new Equipment();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    equipment = this.equipmentService.selectById(id);
                    this.equipmentService.saveLog(request, "\u5220\u9664", equipment);
                }
                this.equipmentService.deleteById(ids);
                this.equipmentExtService.deleteByEquipmentId(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/equipment/list";
    }

    @RequestMapping(value={"exportListExcel"})
    public void exportListExcel(Equipment equipment, Model model, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)equipment.getName())) {
                hostname = equipment.getName();
                params.put("name", hostname.trim());
            }
            if (!StringUtils.isEmpty((CharSequence)equipment.getAccount())) {
                params.put("account", equipment.getAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)equipment.getGroupId())) {
                params.put("groupId", equipment.getGroupId());
            }
            HostUtil.addAccountquery((HttpServletRequest)request, params);
            PageInfo pageInfo = this.equipmentService.selectByParams(params, 1, 20000);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                this.equipmentService.setGroupInList(pageInfo.getList(), model, request);
            }
            this.excelExportService.exportEquipmentListExcel(pageInfo.getList(), response);
        }
        catch (Exception e) {
            logger.error("\u6240\u6709\u8d44\u4ea7\u8bbe\u5907\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u6240\u6709\u8d44\u4ea7\u8bbe\u5907\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", e.toString(), "2");
        }
    }

    @ResponseBody
    @RequestMapping(value={"comment"})
    public String comment(Model model, HttpServletRequest request) {
        String errorMsg = "\u8d44\u4ea7\u8bbe\u5907\u6dfb\u52a0\u5904\u7406\u4fe1\u606f";
        try {
            this.equipmentHandleService.commentWork(request);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return ResDataUtils.resetSuccessJson(null);
    }

    @RequestMapping(value={"delEquipmentHandleById"})
    public String delEquipmentHandleById(Model model, HttpServletRequest request) {
        String errorMsg = "\u5220\u9664\u8d44\u4ea7\u8bbe\u5907\u5904\u7406\u8bb0\u5f55\u9519\u8bef";
        String id = request.getParameter("id");
        try {
            if (!StringUtils.isEmpty((CharSequence)id)) {
                this.equipmentHandleService.deleteById(id.split(","));
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/equipment/list";
    }

    @ResponseBody
    @RequestMapping(value={"saveEquipmentListHideCols"})
    public String saveEquipmentListHideCols(Model model, HttpServletRequest request) {
        try {
            Object[] hostListHideCols = request.getParameterValues("hostListHideCols");
            if (null != hostListHideCols) {
                request.getSession().setAttribute("EquipmentListHideColsInfo", (Object)StringUtils.join((Object[])hostListHideCols, (String)","));
            } else {
                request.getSession().setAttribute("EquipmentListHideColsInfo", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u8d44\u4ea7\u5217\u8868\u9700\u8981\u9690\u85cf\u7684\u5217\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u8d44\u4ea7\u5217\u8868\u9700\u8981\u9690\u85cf\u7684\u5217\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/equipment/list";
    }

    @RequestMapping(value={"getEquipmentQRCode"})
    public void getEquipmentQRCode(HttpServletRequest request, HttpServletResponse response) {
        try {
            String id = request.getParameter("id");
            HashMap<EncodeHintType, Object> map = new HashMap<EncodeHintType, Object>();
            map.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            map.put(EncodeHintType.CHARACTER_SET, "utf-8");
            map.put(EncodeHintType.MARGIN, 1);
            Equipment equipment = this.equipmentService.selectById(id);
            String data = this.equipmentService.getQRCodeData(equipment);
            MultiFormatWriter writer = new MultiFormatWriter();
            BitMatrix bitMatrix = writer.encode(data, BarcodeFormat.QR_CODE, 275, 275, map);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            ImageIO.write((RenderedImage)image, "png", (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u8d44\u4ea7\u8bbe\u5907\u4e8c\u7ef4\u7801\u9519\u8bef", (Throwable)e);
        }
    }
}

