/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.IPUtilInfo;
import com.wgcloud.service.ExcelExportService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.IPUtilInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/ipUtilInfo"})
public class IPUtilInfoController {
    private static final Logger logger = LoggerFactory.getLogger(IPUtilInfoController.class);
    @Resource
    private IPUtilInfoService ipUtilInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private ExcelExportService excelExportService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String IPUtilInfoList(IPUtilInfo ipUtilInfo, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            if (!StringUtils.isEmpty((CharSequence)ipUtilInfo.getIpAddress())) {
                params.put("ipAddress", ipUtilInfo.getIpAddress().trim());
                url.append("&ipAddress=").append(ipUtilInfo.getIpAddress());
            }
            if (!StringUtils.isEmpty((CharSequence)ipUtilInfo.getAccount())) {
                params.put("account", ipUtilInfo.getAccount());
                url.append("&account=").append(ipUtilInfo.getAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)ipUtilInfo.getGroupId())) {
                params.put("groupId", ipUtilInfo.getGroupId());
                url.append("&groupId=").append(ipUtilInfo.getGroupId());
            }
            if (!StringUtils.isEmpty((CharSequence)ipUtilInfo.getIpState())) {
                params.put("ipState", ipUtilInfo.getIpState());
                url.append("&ipState=").append(ipUtilInfo.getIpState());
            }
            HostUtil.addAccountquery((HttpServletRequest)request, params);
            PageInfo pageInfo = this.ipUtilInfoService.selectByParams(params, ipUtilInfo.getPage().intValue(), ipUtilInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                this.ipUtilInfoService.setGroupInList(pageInfo.getList(), model, request);
            }
            HostUtil.addAccountListModel((Model)model);
            model.addAttribute("pageUrl", (Object)("/ipUtilInfo/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("ipUtilInfo", (Object)ipUtilInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2IP\u5730\u5740\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2IP\u5730\u5740\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "ipUtil/list";
    }

    @RequestMapping(value={"save"})
    public String saveIPUtilInfo(IPUtilInfo ipUtilInfo, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)ipUtilInfo.getId())) {
                AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
                if (null != accountInfo && !"admin".equals(accountInfo.getRole())) {
                    ipUtilInfo.setAccount(accountInfo.getAccount());
                }
                this.ipUtilInfoService.save(ipUtilInfo);
                this.ipUtilInfoService.saveLog(request, "\u6dfb\u52a0", ipUtilInfo);
            } else {
                this.ipUtilInfoService.updateById(ipUtilInfo);
                this.ipUtilInfoService.saveLog(request, "\u4fee\u6539", ipUtilInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58IP\u5730\u5740\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58IP\u5730\u5740\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/ipUtilInfo/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0IP\u5730\u5740";
        String id = request.getParameter("id");
        IPUtilInfo ipUtilInfo = new IPUtilInfo();
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("ipUtilInfo", (Object)ipUtilInfo);
                return "ipUtil/add";
            }
            ipUtilInfo = this.ipUtilInfoService.selectById(id);
            model.addAttribute("ipUtilInfo", (Object)ipUtilInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "ipUtil/add";
    }

    @ResponseBody
    @RequestMapping(value={"saveGroupId"})
    public String saveGroupId(Model model, HttpServletRequest request) {
        try {
            String ids = request.getParameter("ids");
            String[] groupIdsArr = request.getParameterValues("groupId");
            this.ipUtilInfoService.saveGroupId(ids, groupIdsArr, request);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58IP\u5730\u5740\u6807\u7b7e\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58IP\u5730\u5740\u6807\u7b7e\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/ipUtilInfo/list";
    }

    @RequestMapping(value={"view"})
    public String viewChart(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770bIP\u5730\u5740\u4fe1\u606f\u9519\u8bef";
        String id = request.getParameter("id");
        IPUtilInfo ipUtilInfo = new IPUtilInfo();
        try {
            ipUtilInfo = this.ipUtilInfoService.selectById(id);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                ipUtilInfo.setGroupId(this.hostGroupService.returnGroupNames(ipUtilInfo.getGroupId()));
            }
            model.addAttribute("ipUtilInfo", (Object)ipUtilInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "ipUtil/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664IP\u5730\u5740\u4fe1\u606f\u9519\u8bef";
        IPUtilInfo IPUtilInfo2 = new IPUtilInfo();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    IPUtilInfo2 = this.ipUtilInfoService.selectById(id);
                    this.ipUtilInfoService.saveLog(request, "\u5220\u9664", IPUtilInfo2);
                }
                this.ipUtilInfoService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/ipUtilInfo/list";
    }

    @RequestMapping(value={"exportListExcel"})
    public void exportListExcel(IPUtilInfo ipUtilInfo, Model model, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (!StringUtils.isEmpty((CharSequence)ipUtilInfo.getIpAddress())) {
                params.put("ipAddress", ipUtilInfo.getIpAddress().trim());
            }
            if (!StringUtils.isEmpty((CharSequence)ipUtilInfo.getAccount())) {
                params.put("account", ipUtilInfo.getAccount());
            }
            if (!StringUtils.isEmpty((CharSequence)ipUtilInfo.getGroupId())) {
                params.put("groupId", ipUtilInfo.getGroupId());
            }
            if (!StringUtils.isEmpty((CharSequence)ipUtilInfo.getIpState())) {
                params.put("ipState", ipUtilInfo.getIpState());
            }
            HostUtil.addAccountquery((HttpServletRequest)request, params);
            PageInfo pageInfo = this.ipUtilInfoService.selectByParams(params, 1, 20000);
            if ("true".equals(this.commonConfig.getHostGroup())) {
                this.ipUtilInfoService.setGroupInList(pageInfo.getList(), model, request);
            }
            this.excelExportService.exportIPUtilInfoListExcel(pageInfo.getList(), response);
        }
        catch (Exception e) {
            logger.error("\u6240\u6709IP\u5730\u5740\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u6240\u6709IP\u5730\u5740\u5217\u8868\u5bfc\u51faexcel\u9519\u8bef", e.toString(), "2");
        }
    }

    @ResponseBody
    @RequestMapping(value={"checkRepeat"})
    public String checkRepeat(Model model, HttpServletRequest request) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String hostname = request.getParameter("hostname");
            if (StringUtils.isEmpty((CharSequence)hostname)) {
                return "0";
            }
            params.put("ipAddress", hostname.trim());
            int count = this.ipUtilInfoService.countByParams(params);
            if (count > 0) {
                return "1";
            }
            return "0";
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8be5IP\u662f\u5426\u5df2\u7ecf\u4fdd\u5b58\u8fc7\u4e86\u9519\u8bef", (Throwable)e);
            return "success";
        }
    }
}

