/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import cn.hutool.json.JSONUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.dto.ChartReportInfo;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.Equipment;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.EquipmentExtService;
import com.wgcloud.service.EquipmentHandleService;
import com.wgcloud.service.EquipmentService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.IPUtilInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.PasswdInfoService;
import com.wgcloud.service.ReportInfoService;
import com.wgcloud.service.ReportInstanceService;
import com.wgcloud.service.ShellNoteInfoService;
import com.wgcloud.util.HostUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class DashboardService {
    private static final Logger logger = LoggerFactory.getLogger(DashboardService.class);
    @Resource
    private EquipmentService equipmentService;
    @Resource
    private AccountInfoService accountInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private HostGroupService hostGroupService;
    @Resource
    private PasswdInfoService passwdInfoService;
    @Resource
    private ShellNoteInfoService shellNoteInfoService;
    @Resource
    private ReportInfoService reportInfoService;
    @Autowired
    private ReportInstanceService reportInstanceService;
    @Resource
    private IPUtilInfoService ipUtilInfoService;
    @Resource
    private EquipmentExtService equipmentExtService;
    @Resource
    private EquipmentHandleService equipmentHandleService;
    @Autowired
    private CommonConfig commonConfig;

    public Integer countSumData() {
        try {
            HashMap params = new HashMap();
            int equipmentCount = this.equipmentService.countByParams(params);
            int equipmentHandleCount = this.equipmentHandleService.countByParams(params);
            int accountInfoCount = this.accountInfoService.countByParams(params);
            int logInfoCount = this.logInfoService.countByParams(params);
            int hostGroupCount = this.hostGroupService.countByParams(params);
            int shellNoteInfoCount = this.shellNoteInfoService.countByParams(params);
            int passwdInfoCount = this.passwdInfoService.countByParams(params);
            int reportInfoCount = this.reportInfoService.countByParams(params);
            int reportInstanceCount = this.reportInstanceService.countByParams(params);
            int ipUtilInfoCount = this.ipUtilInfoService.countByParams(params);
            int equipmentExtCount = this.equipmentExtService.countByParams(params);
            return equipmentCount + equipmentHandleCount + accountInfoCount + logInfoCount + hostGroupCount + shellNoteInfoCount + passwdInfoCount + reportInfoCount + reportInstanceCount + ipUtilInfoCount + equipmentExtCount;
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u5f53\u524d\u7cfb\u7edf\u5185\u6240\u6709\u6570\u636e\u603b\u91cf\u9519\u8bef", (Throwable)e);
            return 0;
        }
    }

    public void setIndexBar(Model model, HttpServletRequest request) throws Exception {
        String[] leibieArr;
        HashMap<String, String> params = new HashMap<String, String>();
        AccountInfo accountInfo = HostUtil.getAccountByRequest((HttpServletRequest)request);
        if (!"admin".equals(accountInfo.getRole())) {
            params.put("account", accountInfo.getAccount());
        }
        ArrayList<ChartReportInfo> chartInfoList = new ArrayList<ChartReportInfo>();
        List leibieList = this.equipmentService.groupByLeibie(params);
        for (String[] equipment : leibieList) {
            ChartReportInfo chartInfoNew = new ChartReportInfo();
            chartInfoNew.setName(equipment.getZiChanLeiBie());
            chartInfoNew.setValue(equipment.getCountSum());
            chartInfoList.add(chartInfoNew);
        }
        for (String leibie : leibieArr = "\u56fa\u5b9a\u8d44\u4ea7,\u6d41\u52a8\u8d44\u4ea7,\u65e0\u5f62\u8d44\u4ea7".split(",")) {
            boolean haved = false;
            for (Equipment equipment : leibieList) {
                if (!leibie.equals(equipment.getZiChanLeiBie())) continue;
                haved = true;
                break;
            }
            if (haved) continue;
            ChartReportInfo chartInfoNew = new ChartReportInfo();
            chartInfoNew.setName(leibie);
            chartInfoNew.setValue(Integer.valueOf(0));
            chartInfoList.add(chartInfoNew);
        }
        String[] workStateArr = this.commonConfig.getWorkState().split(",");
        List stateList = this.equipmentService.groupByState(params);
        for (Equipment equipment : stateList) {
            ChartReportInfo chartInfoNew = new ChartReportInfo();
            chartInfoNew.setName(equipment.getZiChanState());
            chartInfoNew.setValue(equipment.getCountSum());
            chartInfoList.add(chartInfoNew);
        }
        for (String workState : workStateArr) {
            boolean haved = false;
            for (Equipment equipment : stateList) {
                if (!workState.equals(equipment.getZiChanState())) continue;
                haved = true;
                break;
            }
            if (haved) continue;
            ChartReportInfo chartInfoNew = new ChartReportInfo();
            chartInfoNew.setName(workState);
            chartInfoNew.setValue(Integer.valueOf(0));
            chartInfoList.add(chartInfoNew);
        }
        model.addAttribute("equipmentSizeChart", (Object)JSONUtil.parseArray(chartInfoList));
    }
}

