/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.HostGroup;
import com.wgcloud.entity.IPUtilInfo;
import com.wgcloud.mapper.IPUtilInfoMapper;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FileUtils;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class IPUtilInfoService {
    private static final Logger logger = LoggerFactory.getLogger(IPUtilInfoService.class);
    @Autowired
    private IPUtilInfoMapper ipUtilInfoMapper;
    @Autowired
    private LogInfoService logInfoService;
    @Resource
    private HostGroupService hostGroupService;

    public PageInfo<IPUtilInfo> selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.ipUtilInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(IPUtilInfo IPUtilInfo2) throws Exception {
        IPUtilInfo2.setId(UUIDUtil.getUUID());
        IPUtilInfo2.setCreateTime(new Date());
        this.ipUtilInfoMapper.save(IPUtilInfo2);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.ipUtilInfoMapper.deleteById(id);
    }

    public void updateById(IPUtilInfo IPUtilInfo2) throws Exception {
        this.ipUtilInfoMapper.updateById(IPUtilInfo2);
    }

    public IPUtilInfo selectById(String id) throws Exception {
        return this.ipUtilInfoMapper.selectById(id);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.ipUtilInfoMapper.countByParams(params);
    }

    public List<HostGroup> setGroupInList(List<IPUtilInfo> recordList, Model model, HttpServletRequest request) throws Exception {
        HashMap params = new HashMap();
        List hostGroupList = this.hostGroupService.selectAllByParams(params, request);
        model.addAttribute("hostGroupList", (Object)hostGroupList);
        HashMap<String, String> hostGroupMap = new HashMap<String, String>();
        for (HostGroup hostGroup : hostGroupList) {
            hostGroupMap.put(hostGroup.getId(), hostGroup.getGroupName());
        }
        for (IPUtilInfo appInfo : recordList) {
            if (StringUtils.isEmpty((CharSequence)appInfo.getGroupId())) continue;
            String groupNames = "";
            for (String groupId : appInfo.getGroupId().split(",")) {
                if (!hostGroupMap.containsKey(groupId)) continue;
                groupNames = groupNames + (String)hostGroupMap.get(groupId) + ",";
            }
            if (groupNames.endsWith(",")) {
                groupNames = groupNames.substring(0, groupNames.length() - 1);
            }
            appInfo.setGroupId(groupNames);
        }
        return hostGroupList;
    }

    public void saveGroupId(String ids, String[] groupIdsArr, HttpServletRequest request) throws Exception {
        List hostGroupList = new ArrayList();
        if (null != groupIdsArr && groupIdsArr.length > 0) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("groupIds", groupIdsArr);
            hostGroupList = this.hostGroupService.selectAllByParams(params, request);
        }
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            IPUtilInfo ho = null;
            for (String id : ids.split(",")) {
                ho = this.selectById(id);
                if (hostGroupList.size() > 0) {
                    ho.setGroupId(StringUtils.join((Object[])groupIdsArr, (String)","));
                } else {
                    ho.setGroupId("");
                }
                this.updateById(ho);
            }
        }
    }

    public void saveLog(HttpServletRequest request, String action, IPUtilInfo IPUtilInfo2) {
        if (null == IPUtilInfo2) {
            return;
        }
        this.logInfoService.save(HostUtil.getAccountByRequest((HttpServletRequest)request).getAccount() + action + "IP\uff1a" + IPUtilInfo2.getIpAddress(), "IP\uff1a" + IPUtilInfo2.getIpAddress(), "2");
    }

    public void updateToTargetAccount(Map<String, Object> params) throws Exception {
        this.ipUtilInfoMapper.updateToTargetAccount(params);
    }

    public void importExcelIP() {
        try {
            XSSFRow row;
            String filePath = StaticKeys.JAR_PATH + "/template/ip.xlsx";
            if (!FileUtils.existsFile((String)filePath)) {
                return;
            }
            logger.info("\u5f00\u59cb\u4eceexcel\u6587\u4ef6\u5bfc\u5165ip\u6570\u636e-----" + filePath);
            HashMap map = new HashMap();
            XSSFWorkbook workbook = new XSSFWorkbook(filePath);
            XSSFSheet sheet = workbook.getSheetAt(0);
            int firstRowNum = sheet.getFirstRowNum();
            int lastRowNum = sheet.getLastRowNum();
            for (int rowNum = firstRowNum; rowNum <= lastRowNum && null != (row = sheet.getRow(rowNum)); ++rowNum) {
                if (null == row.getCell(0)) continue;
                String cellHostname = row.getCell(0).getStringCellValue();
                if (!StringUtils.isEmpty((CharSequence)cellHostname)) {
                    cellHostname = cellHostname.trim();
                }
                String cellHostMark = "";
                if (null != row.getCell(1)) {
                    cellHostMark = row.getCell(1).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellHostMark)) {
                    cellHostMark = cellHostMark.trim();
                }
                String cellHostMac = "";
                if (null != row.getCell(2)) {
                    cellHostMac = row.getCell(2).getStringCellValue();
                }
                if (!StringUtils.isEmpty((CharSequence)cellHostMac)) {
                    cellHostMac = cellHostMac.trim();
                }
                if (StringUtils.isEmpty((CharSequence)cellHostname)) continue;
                IPUtilInfo ipUtilInfo = new IPUtilInfo();
                ipUtilInfo.setIpAddress(cellHostname);
                ipUtilInfo.setIpRemark(cellHostMark);
                ipUtilInfo.setIpMac(cellHostMac);
                ipUtilInfo.setIpState("1");
                this.save(ipUtilInfo);
            }
            File oldFile = new File(filePath);
            File newFile = new File(StaticKeys.JAR_PATH + "/template/ip_" + DateUtil.getCurrentDateTimeNoChar() + ".xlsx");
            oldFile.renameTo(newFile);
            logger.info("ip\u6570\u636e\u5bfc\u5165\u5b8c\u6210\uff0c\u4fee\u6539\u6587\u4ef6\u540d\u79f0\u4e3a-----" + newFile.getName());
        }
        catch (Exception e) {
            logger.error("ip\u5bfc\u5165excel\u9519\u8bef", (Throwable)e);
        }
    }
}

