/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.ReportInfo;
import com.wgcloud.entity.ReportInstance;
import com.wgcloud.mapper.ReportInfoMapper;
import com.wgcloud.service.ReportInstanceService;
import com.wgcloud.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportInfoService {
    private static final Logger logger = LoggerFactory.getLogger(ReportInfoService.class);
    @Autowired
    private ReportInfoMapper reportInfoMapper;
    @Autowired
    private ReportInstanceService reportInstanceService;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.reportInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(ReportInfo reportInfo, HttpServletRequest request) throws Exception {
        reportInfo.setId(UUIDUtil.getUUID());
        reportInfo.setCreateTime(new Date());
        this.saveReportInfoExtDatas(reportInfo, request);
        try {
            this.reportInfoMapper.save(reportInfo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5de1\u68c0\u62a5\u544a\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    public void updateById(ReportInfo reportInfo, HttpServletRequest request) throws Exception {
        this.saveReportInfoExtDatas(reportInfo, request);
        this.reportInfoMapper.updateById(reportInfo);
    }

    private void saveReportInfoExtDatas(ReportInfo reportInfo, HttpServletRequest request) throws Exception {
        if (null == request) {
            return;
        }
        String xunjianIndex = request.getParameter("xunjianIndex");
        Date dateNow = reportInfo.getCreateTime();
        if (null == dateNow) {
            dateNow = new Date();
        }
        this.reportInstanceService.deleteByReportInfoId(reportInfo.getId());
        ArrayList<ReportInstance> xunjianList = new ArrayList<ReportInstance>();
        if (!StringUtils.isEmpty((CharSequence)xunjianIndex)) {
            for (int i = 0; i <= Integer.valueOf(xunjianIndex); ++i) {
                String infoKey = request.getParameter("infoKey_" + i);
                String infoContent = request.getParameter("infoContent_" + i);
                String checkResult = request.getParameter("checkResult_" + i);
                String checkRemark = request.getParameter("checkRemark_" + i);
                if (StringUtils.isEmpty((CharSequence)infoKey) && StringUtils.isEmpty((CharSequence)infoContent) && StringUtils.isEmpty((CharSequence)checkResult) && StringUtils.isEmpty((CharSequence)checkRemark)) continue;
                ReportInstance reportInstance = new ReportInstance();
                reportInstance.setOrderNum(Integer.valueOf(i));
                reportInstance.setReportInfoId(reportInfo.getId());
                reportInstance.setInfoKey(infoKey);
                reportInstance.setInfoContent(infoContent);
                reportInstance.setCheckRemark(checkRemark);
                reportInstance.setCheckResult(checkResult);
                xunjianList.add(reportInstance);
            }
        }
        if (!CollectionUtil.isEmpty(xunjianList)) {
            this.reportInstanceService.saveRecord(xunjianList, dateNow);
        }
        reportInfo.setCountXunjian(Integer.valueOf(xunjianList.size()));
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.reportInfoMapper.countByParams(params);
    }

    public int deleteById(String[] id) throws Exception {
        return this.reportInfoMapper.deleteById(id);
    }

    public ReportInfo selectById(String id) throws Exception {
        return this.reportInfoMapper.selectById(id);
    }

    public List<ReportInfo> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.reportInfoMapper.selectAllByParams(params);
    }
}

