/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.task;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.MailSet;
import com.wgcloud.service.AccountInfoService;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.EquipmentExtService;
import com.wgcloud.service.EquipmentService;
import com.wgcloud.service.IPUtilInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.MailSetService;
import com.wgcloud.service.PasswdInfoService;
import com.wgcloud.util.DESUtil;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.RestUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTask {
    private Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    @Autowired
    private LogInfoService logInfoService;
    @Autowired
    private MailSetService mailSetService;
    @Autowired
    private AccountInfoService accountInfoService;
    @Resource
    private DashboardService dashboardService;
    @Resource
    private PasswdInfoService passwdInfoService;
    @Resource
    private EquipmentService equipmentService;
    @Resource
    private EquipmentExtService equipmentExtService;
    @Resource
    private IPUtilInfoService ipUtilInfoService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private RestUtil restUtil;

    @Scheduled(initialDelay=5000L, fixedRate=86400000L)
    public void validateLicense() {
        this.logger.info("validateLicense------------" + DateUtil.getDateTimeString((Date)new Date()));
        try {
            this.servletContext.setAttribute("icoUrl", (Object)(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/logincss/favicon.png"));
            this.servletContext.setAttribute("logoUrl", (Object)(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/logincss/logo.png"));
            this.servletContext.setAttribute("wgName", (Object)"WGFIX\u8d44\u4ea7\u8bbe\u5907\u7ba1\u7406\u7cfb\u7edf");
            this.servletContext.setAttribute("wgShortName", (Object)"WGFIX");
            HashMap params = new HashMap();
            int listAgentNum = this.accountInfoService.countByParams(params);
            StaticKeys.LICENSE_STATE = LicenseUtil.validateLicense((int)listAgentNum, (int)this.commonConfig.getPageSize());
            this.servletContext.setAttribute("LICENSE_STATE", (Object)StaticKeys.LICENSE_STATE);
            this.servletContext.setAttribute("LICENSE_DATE", (Object)StaticKeys.LICENSE_DATE);
            this.servletContext.setAttribute("LICENSE_NAME", (Object)StaticKeys.LICENSE_NAME);
            if (!StringUtils.isEmpty((CharSequence)StaticKeys.LICENSE_DATE) && StaticKeys.LICENSE_DATE.startsWith("2099")) {
                this.servletContext.setAttribute("LICENSE_DATE", (Object)"\u6c38\u4e45\u6388\u6743");
            }
            if (StaticKeys.LICENSE_STATE.equals("0") && listAgentNum > 5) {
                StaticKeys.LICENSE_STATE = "3";
            }
            LicenseUtil.initAllowDataCount();
            this.servletContext.setAttribute("allowDataCountNum", (Object)FormatUtil.numToWStr((Integer)StaticKeys.ALLOW_DATA_COUNT_NUM));
            this.servletContext.setAttribute("LICENSE_NUM", (Object)StaticKeys.LICENSE_NUM);
            this.servletContext.setAttribute("LICENSE_HIDE_VERSION", (Object)StaticKeys.LICENSE_HIDE_VERSION);
            this.servletContext.setAttribute("copyRight", (Object)"true");
            this.servletContext.setAttribute("copyRightLoginContent", (Object)"");
            this.servletContext.setAttribute("copyRightMainContent", (Object)"");
            if (StaticKeys.LICENSE_STATE.equals("1")) {
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getIcoName())) {
                    this.servletContext.setAttribute("icoUrl", (Object)(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/resources/" + this.commonConfig.getIcoName()));
                }
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getLogoName())) {
                    this.servletContext.setAttribute("logoUrl", (Object)(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/resources/" + this.commonConfig.getLogoName()));
                }
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getWgName())) {
                    this.servletContext.setAttribute("wgName", (Object)this.commonConfig.getWgName());
                }
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getWgShortName())) {
                    this.servletContext.setAttribute("wgShortName", (Object)this.commonConfig.getWgShortName());
                }
                this.servletContext.setAttribute("copyRight", (Object)this.commonConfig.getCopyRight());
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getCopyRightLoginContent()) && "yes".equals(StaticKeys.LICENSE_COPYRIGHT_UPDATE)) {
                    this.servletContext.setAttribute("copyRightLoginContent", (Object)this.commonConfig.getCopyRightLoginContent());
                }
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getCopyRightMainContent()) && "yes".equals(StaticKeys.LICENSE_COPYRIGHT_UPDATE)) {
                    this.servletContext.setAttribute("copyRightMainContent", (Object)this.commonConfig.getCopyRightMainContent());
                }
            }
            if (!(StaticKeys.LICENSE_STATE.equals("1") && "yes".equals(StaticKeys.LICENSE_DIY_CONTEXT_PATH) || "/wgfix".equals(StaticKeys.SERVER_SERVLET_CONTEXT_PATH))) {
                StaticKeys.SERVER_SERVLET_CONTEXT_PATH = "";
                this.servletContext.setAttribute("SERVER_SERVLET_CONTEXT_PATH", (Object)"");
            }
            this.equipmentService.setEquipmentColNames();
            this.equipmentExtService.setEquipmentExtColNames();
            String daemonMd5Str = this.restUtil.get(this.commonConfig.getDaemonUrl());
            if (!daemonMd5Str.equals(StaticKeys.WGCLOUD_CAT_RELEASE_JAR_MD5)) {
                StaticKeys.WGCLOUD_CAT_RELEASE_JAR_STATE = "ERROR";
                this.logger.error("wgfix-release.jar\u5df2\u7ecf\u88ab\u7be1\u6539\uff0c\u8bf7\u8fd8\u539f");
            }
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4blicense\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=15000L, fixedRate=3600000L)
    public void sumDataSizeCacheTask() {
        this.logger.info("sumDataSizeCacheTask------------" + DateUtil.getDateTimeString((Date)new Date()));
        try {
            Integer countSumData = this.dashboardService.countSumData();
            this.servletContext.setAttribute("countSumData", (Object)FormatUtil.numToWStr((Integer)countSumData));
            this.logger.info("\u7cfb\u7edf\u5f53\u524d\u6570\u636e\u603b\u91cf------------" + countSumData);
            if (StaticKeys.ALLOW_DATA_COUNT_NUM < countSumData) {
                StaticKeys.LICENSE_STATE = "3";
                this.logger.info("\u7cfb\u7edf\u5f53\u524d\u6570\u636e\u603b\u91cf\u8d85\u8fc7\u514d\u8d39\u7248\u6570\u636e\u603b\u91cf------------50000");
            }
            if (StaticKeys.LICENSE_STATE.equals("1")) {
                this.passwdInfoService.importExcelPasswd();
                this.equipmentService.importExcelEquipment();
                this.ipUtilInfoService.importExcelIP();
            }
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u8ba1\u603b\u6570\u636e\u91cf\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=20000L, fixedRate=360000L)
    public void initTask() {
        this.logger.info("initTask------------" + DateUtil.getDateTimeString((Date)new Date()));
        try {
            HashMap params = new HashMap();
            List list = this.mailSetService.selectAllByParams(params);
            if (list.size() > 0) {
                MailSet selectMailSet = (MailSet)list.get(0);
                if (!"2".equals(selectMailSet.getActive())) {
                    selectMailSet.setFromPwd(DESUtil.decryptForServerDb((String)selectMailSet.getFromPwd()));
                    StaticKeys.mailSet = selectMailSet;
                } else {
                    this.logger.info("\u5df2\u8bbe\u7f6e\u6682\u505c\u90ae\u4ef6\u544a\u8b66\u53d1\u9001");
                    StaticKeys.mailSet = null;
                }
            } else {
                StaticKeys.mailSet = null;
            }
            List accountInfoList = this.accountInfoService.selectAllByParams(new HashMap());
            StaticKeys.ACCOUNT_INFO_MAP.clear();
            for (AccountInfo accountInfo : accountInfoList) {
                StaticKeys.ACCOUNT_INFO_MAP.put(accountInfo.getAccount(), accountInfo);
            }
            DateUtil.checkPwdExp((String)this.commonConfig.getPwdExpDate());
        }
        catch (Exception e) {
            this.logger.error("initTask\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(cron="0 0 12 ? * MON,WED")
    public void checkExpWeibaoDate() {
        this.logger.info("\u68c0\u67e5\u8d44\u4ea7\u8bbe\u5907\u7684\u7ef4\u4fdd\u5230\u671f\u65f6\u95f4\u4efb\u52a1----------" + DateUtil.getCurrentDateTime());
        try {
            this.equipmentService.checkExpWeibaoDate();
            StaticKeys.LOGIN_BLOCK_MAP.clear();
            StaticKeys.LOGIN_ERROR_MAP.clear();
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u67e5\u8d44\u4ea7\u8bbe\u5907\u7684\u7ef4\u4fdd\u5230\u671f\u65f6\u95f4\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }
}

