/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.service.FileWarnInfoService;
import com.wgcloud.service.HostInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.mongo.PageResultDto;
import com.wgcloud.util.mongo.ParamDto;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hostInfo"})
public class HostInfoController {
    private static final Logger logger = LoggerFactory.getLogger(HostInfoController.class);
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private HostInfoService hostInfoService;
    @Resource
    private FileWarnInfoService fileWarnInfoService;

    @RequestMapping(value={"list"})
    public String hostInfoList(HostInfo hostInfo, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            LicenseUtil.maxLicense_10((Model)model, (HttpServletRequest)request, (Object)hostInfo);
            StringBuffer url = new StringBuffer();
            ArrayList<ParamDto> paramDtoList = new ArrayList<ParamDto>();
            if (!StringUtils.isEmpty((CharSequence)hostInfo.getHostname())) {
                url.append("&hostname=").append(hostInfo.getHostname());
                paramDtoList.add(new ParamDto("hostname", "like", hostInfo.getHostname()));
            }
            if (!StringUtils.isEmpty((CharSequence)hostInfo.getState())) {
                url.append("&state=").append(hostInfo.getState());
                paramDtoList.add(new ParamDto("state", "eq", hostInfo.getState()));
            }
            PageResultDto pageInfo = this.hostInfoService.selectByParams(paramDtoList, hostInfo.getPage().intValue(), hostInfo.getPageSize().intValue());
            ArrayList<ParamDto> paramDtoFileLogList = new ArrayList<ParamDto>();
            for (HostInfo hostInfo1 : pageInfo.getList()) {
                paramDtoFileLogList.clear();
                paramDtoFileLogList.add(new ParamDto("hostname", "eq", hostInfo1.getHostname()));
                hostInfo1.setFileLogNum(this.fileWarnInfoService.countByParams(paramDtoFileLogList) + "");
            }
            PageUtil.initPageNumber((PageResultDto)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/hostInfo/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("hostInfo", (Object)hostInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u76d1\u63a7\u7684\u4e3b\u673a\u5217\u8868\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u76d1\u63a7\u7684\u4e3b\u673a\u5217\u8868\u9519\u8bef", e.toString(), "2");
        }
        return "hostInfo/list";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request) {
        String errorMsg = "\u5220\u9664\u4e3b\u673a\u9519\u8bef";
        try {
            HostInfo hostInfo = new HostInfo();
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    hostInfo = this.hostInfoService.selectById(id);
                    this.logInfoService.save("\u5220\u9664\u4e3b\u673a\uff1a" + hostInfo.getHostname(), "\u5220\u9664\u4e3b\u673a\uff1a" + hostInfo.getHostname(), "2");
                }
                this.hostInfoService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/hostInfo/list";
    }

    @ResponseBody
    @RequestMapping(value={"saveRemark"})
    public String saveHostRemark(HostInfo hostInfo, Model model, HttpServletRequest request) {
        try {
            if (!StringUtils.isEmpty((CharSequence)hostInfo.getId())) {
                this.hostInfoService.updateById(hostInfo);
                this.logInfoService.save("\u4fee\u6539\u4e3b\u673a\u5907\u6ce8\uff1a" + hostInfo.getHostname(), "\u4e3b\u673a\u5907\u6ce8\uff1a" + hostInfo.getRemark(), "2");
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4e3b\u673a\u5907\u6ce8\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u4e3b\u673a\u5907\u6ce8\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/hostInfo/list";
    }
}

