/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.service.FileWarnInfoService;
import com.wgcloud.service.HostInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.LogSizeInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/logAnalysis"})
public class LogAnalysisController {
    private static final Logger logger = LoggerFactory.getLogger(LogAnalysisController.class);
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private LogSizeInfoService logSizeInfoService;
    @Resource
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private HostInfoService hostInfoService;
    @Resource
    private FileWarnInfoService fileWarnInfoService;

    @RequestMapping(value={"list"})
    public String hostInfoList(HostInfo hostInfo, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            String days = request.getParameter("am");
            if (StringUtils.isEmpty((CharSequence)days)) {
                days = "am1";
            }
            if (!StaticKeys.LICENSE_STATE.equals("1") && !"am1".equals(days)) {
                days = "am1";
                model.addAttribute("msg", (Object)"\u4e2a\u4eba\u7248\u53ea\u80fd\u67e5\u770b\u6700\u8fd17\u5929\u56fe\u8868\uff0c\u8bf7\u70b9\u51fb\u9875\u9762\u5e95\u90e8\u7f51\u7ad9\uff0c\u8054\u7cfb\u6211\u4eec\u5347\u7ea7\u5230\u4e13\u4e1a\u7248");
            }
            this.logSizeInfoService.setDateParam(days, params, model);
            model.addAttribute("amList", (Object)this.logSizeInfoService.getDayListParam());
            Query query = new Query();
            Criteria criteria = new Criteria();
            if (null != params.get("startTime") || null != params.get("endTime")) {
                criteria.and("createTime").gte((Object)DateUtil.getDate((String)params.get("startTime").toString())).lte((Object)DateUtil.getDate((String)params.get("endTime").toString()));
            }
            query.addCriteria((CriteriaDefinition)criteria);
            List logSizeInfoList = this.logSizeInfoService.selectAllByParams(query);
            this.logSizeInfoService.setSubtitle(model, logSizeInfoList);
            model.addAttribute("logSizeInfoList", (Object)JSONUtil.parseArray((Object)logSizeInfoList));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6bcf\u5929\u91c7\u96c6\u7684\u65e5\u5fd7\u5927\u5c0f\u5217\u8868\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u6bcf\u5929\u91c7\u96c6\u7684\u65e5\u5fd7\u5927\u5c0f\u5217\u8868\u9519\u8bef", e.toString(), "2");
        }
        return "analysis/list";
    }
}

