/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONObject;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.MongoDatabase;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.LogSizeInfoService;
import com.wgcloud.util.TokenUtils;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/mongoInfo"})
public class MongoInfoController {
    private static final Logger logger = LoggerFactory.getLogger(MongoInfoController.class);
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private LogSizeInfoService logSizeInfoService;
    @Resource
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private MongoTemplate mongoTemplate;

    @RequestMapping(value={"list"})
    public String collectionList(HostInfo hostInfo, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            ArrayList<JSONObject> collectionNames = new ArrayList<JSONObject>();
            ListCollectionsIterable collections = this.mongoTemplate.getDb().listCollections();
            for (Document collection : collections) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("name", (Object)collection.getString((Object)"name"));
                Long count = this.mongoTemplate.getCollection(collection.getString((Object)"name")).estimatedDocumentCount();
                jsonObject.set("count", (Object)count);
                collectionNames.add(jsonObject);
            }
            model.addAttribute("collectionList", collectionNames);
            MongoDatabase db = this.mongoTemplate.getDb();
            model.addAttribute("MongoDatabaseName", (Object)db.getName());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u6240\u6709\u7684\u96c6\u5408\u540d\u79f0\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u6240\u6709\u7684\u96c6\u5408\u540d\u79f0\u9519\u8bef", e.toString(), "2");
        }
        return "mongo/list";
    }
}

