/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.entity.FileWarnState;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.mongo.MongoBaseService;
import com.wgcloud.util.mongo.MongodbToolUtil;
import com.wgcloud.util.mongo.PageQueryDto;
import com.wgcloud.util.mongo.PageResultDto;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class FileWarnStateService {
    private Logger logger = LoggerFactory.getLogger(FileWarnStateService.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoBaseService mongoBaseService;

    public PageResultDto selectByParams(List paramDtoList, int currPage, int pageSize) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(pageSize));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(currPage));
        pageQueryDto.setParams(paramDtoList);
        PageResultDto result = MongodbToolUtil.selectByParams((PageQueryDto)pageQueryDto, FileWarnState.class, (MongoTemplate)this.mongoTemplate, (String)"_id", (String)"DESC");
        return result;
    }

    public PageResultDto selectByParams(List paramDtoList, int currPage, int pageSize, String collectionName) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(pageSize));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(currPage));
        pageQueryDto.setParams(paramDtoList);
        PageResultDto result = MongodbToolUtil.selectByParams((PageQueryDto)pageQueryDto, FileWarnState.class, (MongoTemplate)this.mongoTemplate, (String)"createTime", (String)"DESC", (String)("FILE_WARN_STATE_" + collectionName));
        return result;
    }

    public Long countByParams(List paramDtoList) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(20));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(1));
        pageQueryDto.setParams(paramDtoList);
        Query query = MongodbToolUtil.handleParam((PageQueryDto)pageQueryDto);
        long count = this.mongoTemplate.count(query, FileWarnState.class);
        return count;
    }

    public void save(FileWarnState fileWarnState) {
        try {
            fileWarnState.setId(UUIDUtil.getUUID());
            fileWarnState.setCreateTime(new Date());
            this.mongoTemplate.save((Object)fileWarnState);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
    }

    public void save(FileWarnState fileWarnState, String collectionName) {
        try {
            fileWarnState.setId(UUIDUtil.getUUID());
            fileWarnState.setCreateTime(new Date());
            this.mongoTemplate.save((Object)fileWarnState, "FILE_WARN_STATE_" + collectionName);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
    }

    public void deleteById(String[] id) {
        try {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in((Object[])id));
            this.mongoTemplate.remove(query, FileWarnState.class);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u9519\u8bef", (Throwable)e);
        }
    }

    public FileWarnState selectById(String id) throws Exception {
        return (FileWarnState)this.mongoTemplate.findById((Object)id, FileWarnState.class);
    }

    public FileWarnState selectById(String id, String collectionName) throws Exception {
        return (FileWarnState)this.mongoTemplate.findById((Object)id, FileWarnState.class, "FILE_WARN_STATE_" + collectionName);
    }

    public List<FileWarnState> selectByIdArray(String ids) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        List<String> values = Arrays.asList(ids.split(","));
        criteria.and("_id").in(values);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"_id")}));
        return this.mongoTemplate.find(query, FileWarnState.class);
    }

    public List<FileWarnState> selectByIdArray(String ids, String collectionName) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        List<String> values = Arrays.asList(ids.split(","));
        criteria.and("_id").in(values);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"_id")}));
        return this.mongoTemplate.find(query, FileWarnState.class, "FILE_WARN_STATE_" + collectionName);
    }
}

