/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.entity.MailSet;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.mongo.MongoBaseService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MailSetService {
    private static final Logger logger = LoggerFactory.getLogger(MailSetService.class);
    @Autowired
    private LogInfoService logInfoService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoBaseService mongoBaseService;

    public void save(MailSet mailSet) throws Exception {
        mailSet.setId(UUIDUtil.getUUID());
        mailSet.setCreateTime(new Date());
        mailSet.setFromMailName(mailSet.getFromMailName().trim());
        mailSet.setFromPwd(mailSet.getFromPwd().trim());
        mailSet.setToMail(mailSet.getToMail().trim());
        mailSet.setSmtpHost(mailSet.getSmtpHost().trim());
        try {
            this.mongoBaseService.save((Object)mailSet);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u90ae\u4ef6\u8bbe\u7f6e\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    public void saveLog(HttpServletRequest request, String action, MailSet mailSet) {
        if (null == mailSet) {
            return;
        }
        this.logInfoService.save("\u7ba1\u7406\u5458" + action + "\u90ae\u4ef6\u8bbe\u7f6e\u4fe1\u606f", "\u63a5\u53d7\u90ae\u4ef6\uff1a" + mailSet.getToMail(), "2");
    }

    public void deleteById(String[] id) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        this.mongoTemplate.remove(query, MailSet.class);
    }

    public List<MailSet> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.mongoBaseService.listByQuery(null, (Object)new MailSet());
    }

    public void updateById(MailSet mailSet) throws Exception {
        this.deleteById(mailSet.getId().split(","));
        this.save(mailSet);
    }
}

