/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormatUtil {
    private static Logger logger = LoggerFactory.getLogger(FormatUtil.class);

    public static String timesToDay(Long l) {
        if (l == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        long seconds = 1L;
        long minutes = 60L * seconds;
        long hours = 60L * minutes;
        long days = 24L * hours;
        if (l / days >= 1L) {
            sb.append((int)(l / days) + "\u5929");
        }
        if (l % days / hours >= 1L) {
            sb.append((int)(l % days / hours) + "\u5c0f\u65f6");
        }
        if (l % days % hours / minutes >= 1L) {
            sb.append((int)(l % days % hours / minutes) + "\u5206\u949f");
        }
        return sb.toString();
    }

    public static String secondsToDays(Long l) {
        if (l == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        long seconds = 1L;
        long minutes = 60L * seconds;
        long hours = 60L * minutes;
        long days = 24L * hours;
        if (l / days >= 1L) {
            sb.append((int)(l / days) + "\u5929");
        }
        return sb.toString();
    }

    public static String getString(String str, int len) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String bytesFormatUnit(String str) {
        if (StringUtils.isEmpty((CharSequence)str) || "0".equals(str)) {
            return "0B";
        }
        if (str.indexOf(".") > -1) {
            str = str.substring(0, str.indexOf("."));
        }
        try {
            long bytes = Long.valueOf(str);
            int k = 1024;
            String[] sizes = new String[]{"B", "KB", "MB", "GB", "T", "P", "E", "Z", "Y"};
            int i = (int)Math.floor(Math.log(bytes) / Math.log(k));
            if (i > sizes.length - 1) {
                i = sizes.length - 1;
            }
            return FormatUtil.formatDouble((Double)((double)bytes / Math.pow(k, i)), (int)2) + sizes[i];
        }
        catch (Exception e) {
            logger.error("bytesFormatUnit\u9519\u8bef", (Throwable)e);
            return str + "B";
        }
    }

    public static String bytesFormatUnit(String str, String snmpUnit) {
        if (StringUtils.isEmpty((CharSequence)str) || "0".equals(str)) {
            return "0B";
        }
        if (str.indexOf(".") > -1) {
            str = str.substring(0, str.indexOf("."));
        }
        try {
            long bytes = Long.valueOf(str);
            if (!"byte".equals(snmpUnit)) {
                bytes *= 1024L;
            }
            int k = 1024;
            String[] sizes = new String[]{"B", "KB", "MB", "GB", "T", "P", "E", "Z", "Y"};
            int i = (int)Math.floor(Math.log(bytes) / Math.log(k));
            if (i > sizes.length - 1) {
                i = sizes.length - 1;
            }
            return FormatUtil.formatDouble((Double)((double)bytes / Math.pow(k, i)), (int)2) + sizes[i];
        }
        catch (Exception e) {
            logger.error("bytesFormatUnit\u9519\u8bef", (Throwable)e);
            return str + "B";
        }
    }

    public static double formatDouble(Double str, int num) {
        if (str == null) {
            return 0.0;
        }
        try {
            BigDecimal b = new BigDecimal(str);
            double myNum3 = b.setScale(num, 4).doubleValue();
            return myNum3;
        }
        catch (Exception e) {
            logger.error("formatDouble\u9519\u8bef\uff1a", (Throwable)e);
            return 0.0;
        }
    }

    public static double formatDouble(String str, int num) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0;
        }
        Double strDou = Double.valueOf(str);
        BigDecimal b = new BigDecimal(strDou);
        double myNum3 = b.setScale(num, 4).doubleValue();
        return myNum3;
    }

    public static String toLowerStr(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        return str.toLowerCase();
    }

    public static boolean isNumber(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        Boolean strResult = str.matches("-?[0-9]+.?[0-9]*");
        return strResult == true;
    }

    public static String haveSqlDanger(String sql, String sqlInKeys) {
        String[] sqlinkeys;
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return "";
        }
        sql = sql.toLowerCase();
        sqlInKeys = sqlInKeys.toLowerCase();
        for (String sqlinkey : sqlinkeys = sqlInKeys.split(",")) {
            if (sql.indexOf(sqlinkey) <= -1) continue;
            return sqlinkey;
        }
        return "";
    }

    public static String haveBlockDanger(String shell, String shellBlock) {
        String[] blocks;
        if (StringUtils.isEmpty((CharSequence)shell)) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)shellBlock)) {
            return "";
        }
        shell = shell.toLowerCase();
        shellBlock = shellBlock.toLowerCase();
        for (String blockStr : blocks = shellBlock.split(",")) {
            if (shell.indexOf(blockStr) <= -1) continue;
            return blockStr;
        }
        return "";
    }

    public static boolean validateExpression(String expression, Object value) {
        if (StringUtils.isEmpty((CharSequence)expression) || null == value) {
            return false;
        }
        logger.info("\u6570\u636e\u76d1\u63a7\u544a\u8b66\u8868\u8fbe\u5f0f---------" + expression);
        Expression compiledExp = AviatorEvaluator.compile((String)expression);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("result", value);
        Boolean result = (Boolean)compiledExp.execute(env);
        return result;
    }

    public static boolean validateExpression(String expression, Map<String, Object> env) {
        if (StringUtils.isEmpty((CharSequence)expression) || null == env) {
            return false;
        }
        logger.info("\u81ea\u5b9a\u4e49\u76d1\u63a7\u544a\u8b66\u8868\u8fbe\u5f0f---------" + expression);
        Expression compiledExp = AviatorEvaluator.compile((String)expression);
        Boolean result = (Boolean)compiledExp.execute(env);
        return result;
    }

    public static int getRandInt() {
        Random random = new Random();
        int randomNum = random.nextInt(900) + 100;
        return randomNum;
    }

    public static String numToWStr(Integer num) {
        try {
            if (null == num) {
                return "NULL";
            }
            if (num < 10000) {
                return num + "";
            }
            double result = (double)num.intValue() / 10000.0;
            result = FormatUtil.formatDouble((Double)result, (int)2);
            return result + "W";
        }
        catch (Exception e) {
            logger.error("numToWStr\u9519\u8bef", (Throwable)e);
            return num + "";
        }
    }

    public static String numToKStr(Long num) {
        try {
            if (null == num) {
                return "NULL";
            }
            if (num < 1000L) {
                return num + "";
            }
            double result = (double)num.longValue() / 1000.0;
            result = FormatUtil.formatDouble((Double)result, (int)1);
            return result + "K";
        }
        catch (Exception e) {
            logger.error("numToKStr\u9519\u8bef", (Throwable)e);
            return num + "";
        }
    }
}

