/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.util.staticvar.StaticKeys;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostUtil {
    private static Logger logger = LoggerFactory.getLogger(HostUtil.class);

    public static String getNameSpace(String bindIp) {
        if (StringUtils.isEmpty((CharSequence)bindIp)) {
            return "";
        }
        String nameSpace = "";
        for (HostInfo hostInfo : StaticKeys.HOST_INFO_LIST) {
            if (!bindIp.equals(hostInfo.getHostname())) continue;
            return hostInfo.getNameSpace();
        }
        return nameSpace;
    }

    public static String addRemark(String hostname) {
        if (StringUtils.isEmpty((CharSequence)hostname)) {
            return "";
        }
        for (HostInfo hostInfo : StaticKeys.HOST_INFO_LIST) {
            if (!hostname.equals(hostInfo.getHostname()) || StringUtils.isEmpty((CharSequence)hostInfo.getRemark())) continue;
            return "(" + hostInfo.getRemark() + ")";
        }
        return "";
    }

    public static AccountInfo getAccountByRequest(HttpServletRequest request) {
        AccountInfo accountInfo = (AccountInfo)request.getSession().getAttribute("LOGIN_KEY");
        if (accountInfo == null) {
            return new AccountInfo();
        }
        return accountInfo;
    }
}

