/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.entity.FileWarnState;
import com.wgcloud.service.FileWarnInfoService;
import com.wgcloud.service.FileWarnStateService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.mongo.PageResultDto;
import com.wgcloud.util.mongo.ParamDto;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/fileWarnState"})
public class FileWarnStateController {
    private static final Logger logger = LoggerFactory.getLogger(FileWarnStateController.class);
    @Resource
    private FileWarnInfoService fileWarnInfoService;
    @Resource
    private FileWarnStateService fileWarnStateService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String stateList(FileWarnState fileWarnState, Model model, HttpServletRequest request) {
        try {
            StringBuffer url = new StringBuffer();
            FileWarnInfo fileWarnInfo = null;
            ArrayList<ParamDto> paramDtoList = new ArrayList<ParamDto>();
            if (!StringUtils.isEmpty((CharSequence)fileWarnState.getFileWarnId())) {
                fileWarnInfo = this.fileWarnInfoService.selectById(fileWarnState.getFileWarnId());
                url.append("&fileWarnId=").append(fileWarnState.getFileWarnId());
                paramDtoList.add(new ParamDto("fileWarnId", "eq", fileWarnState.getFileWarnId()));
            }
            if (!StringUtils.isEmpty((CharSequence)fileWarnState.getFilePath())) {
                url.append("&filePath=").append(fileWarnState.getFilePath());
                paramDtoList.add(new ParamDto("filePath", "like", fileWarnState.getFilePath()));
            }
            if (!StringUtils.isEmpty((CharSequence)fileWarnState.getGatherLogContent())) {
                url.append("&gatherLogContent=").append(fileWarnState.getGatherLogContent());
                paramDtoList.add(new ParamDto("gatherLogContent", "like", fileWarnState.getGatherLogContent()));
            }
            Integer pageSize = fileWarnState.getPageSize();
            String requestPageSize = request.getParameter("pageSizeValue");
            if (!StringUtils.isEmpty((CharSequence)requestPageSize)) {
                pageSize = Integer.valueOf(requestPageSize);
                model.addAttribute("pageSizeValue", (Object)requestPageSize);
                url.append("&pageSizeValue=").append(requestPageSize);
            }
            PageResultDto pageInfo = null;
            if (fileWarnInfo != null) {
                String nameSpace = HostUtil.getNameSpace((String)fileWarnInfo.getHostname());
                pageInfo = StringUtils.isEmpty((CharSequence)nameSpace) ? this.fileWarnStateService.selectByParams(paramDtoList, fileWarnState.getPage().intValue(), pageSize.intValue()) : this.fileWarnStateService.selectByParams(paramDtoList, fileWarnState.getPage().intValue(), pageSize.intValue(), nameSpace);
            }
            for (FileWarnState fileWarnStateTmp : pageInfo.getList()) {
                if (StringUtils.isEmpty((CharSequence)fileWarnStateTmp.getStartRows()) || StringUtils.isEmpty((CharSequence)fileWarnStateTmp.getWarnRows())) continue;
                Integer diffRows = 0;
                diffRows = Integer.valueOf(fileWarnStateTmp.getWarnRows()) - Integer.valueOf(fileWarnStateTmp.getStartRows());
                fileWarnStateTmp.setDiffRows(diffRows + "");
            }
            PageUtil.initPageNumber(pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/fileWarnState/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
            fileWarnInfo.setHostname(fileWarnInfo.getHostname() + HostUtil.addRemark((String)fileWarnInfo.getHostname()));
            model.addAttribute("fileWarnState", (Object)fileWarnState);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "fileState/list";
    }

    @RequestMapping(value={"view"})
    public String stateView(FileWarnState fileWarnState, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            FileWarnInfo fileWarnInfo = this.fileWarnInfoService.selectById(fileWarnState.getFileWarnId());
            String nameSpace = HostUtil.getNameSpace((String)fileWarnInfo.getHostname());
            fileWarnState = StringUtils.isEmpty((CharSequence)nameSpace) ? this.fileWarnStateService.selectById(fileWarnState.getId()) : this.fileWarnStateService.selectById(fileWarnState.getId(), nameSpace);
            model.addAttribute("fileWarnState", (Object)fileWarnState);
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
            fileWarnInfo.setHostname(fileWarnInfo.getHostname() + HostUtil.addRemark((String)fileWarnInfo.getHostname()));
            model.addAttribute("fileWarnId", (Object)fileWarnInfo.getId());
            model.addAttribute("fileWarnStateIds", (Object)fileWarnState.getId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", e.toString(), "2");
        }
        return "fileState/view";
    }

    @RequestMapping(value={"viewMany"})
    public String viewMany(FileWarnState fileWarnState, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            FileWarnInfo fileWarnInfo = this.fileWarnInfoService.selectById(fileWarnState.getFileWarnId());
            String nameSpace = HostUtil.getNameSpace((String)fileWarnInfo.getHostname());
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                List list = new ArrayList();
                list = StringUtils.isEmpty((CharSequence)nameSpace) ? this.fileWarnStateService.selectByIdArray(request.getParameter("id")) : this.fileWarnStateService.selectByIdArray(request.getParameter("id"), nameSpace);
                FileWarnState fileWarnStateResult = new FileWarnState();
                fileWarnStateResult = (FileWarnState)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    fileWarnStateResult.setGatherLogContent(((FileWarnState)list.get(i)).getGatherLogContent() + fileWarnStateResult.getGatherLogContent());
                    fileWarnStateResult.setStartRows(((FileWarnState)list.get(i)).getStartRows());
                }
                model.addAttribute("fileWarnState", (Object)fileWarnStateResult);
            }
            model.addAttribute("fileWarnId", (Object)fileWarnState.getFileWarnId());
            model.addAttribute("fileWarnStateIds", (Object)request.getParameter("id"));
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
            fileWarnInfo.setHostname(fileWarnInfo.getHostname() + HostUtil.addRemark((String)fileWarnInfo.getHostname()));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", e.toString(), "2");
        }
        return "fileState/view";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportLog"})
    public void exportTxt(HttpServletResponse response, HttpServletRequest request) {
        FilterOutputStream buff = null;
        ServletOutputStream outStr = null;
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar();
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/plain");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName + ".log");
            String fileWarnId = request.getParameter("fileWarnId");
            String fileWarnStateIds = request.getParameter("fileWarnStateIds");
            FileWarnInfo fileWarnInfo = this.fileWarnInfoService.selectById(fileWarnId);
            String nameSpace = HostUtil.getNameSpace((String)fileWarnInfo.getHostname());
            FileWarnState fileWarnStateResult = new FileWarnState();
            if (!StringUtils.isEmpty((CharSequence)fileWarnStateIds)) {
                List list = new ArrayList();
                list = StringUtils.isEmpty((CharSequence)nameSpace) ? this.fileWarnStateService.selectByIdArray(fileWarnStateIds) : this.fileWarnStateService.selectByIdArray(fileWarnStateIds, nameSpace);
                fileWarnStateResult = (FileWarnState)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    fileWarnStateResult.setGatherLogContent(((FileWarnState)list.get(i)).getGatherLogContent() + "</br>" + fileWarnStateResult.getGatherLogContent());
                    fileWarnStateResult.setStartRows(((FileWarnState)list.get(i)).getStartRows());
                }
            }
            fileWarnStateResult.setGatherLogContent(fileWarnStateResult.getGatherLogContent().replaceAll("</br>", "\n"));
            outStr = response.getOutputStream();
            buff = new BufferedOutputStream((OutputStream)outStr);
            buff.write(fileWarnStateResult.getGatherLogContent().getBytes("UTF-8"));
            ((BufferedOutputStream)buff).flush();
            buff.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (buff != null) {
                    buff.close();
                }
                if (outStr != null) {
                    outStr.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6d41\u5bf9\u8c61\u51fa\u9519", (Throwable)e);
            }
        }
    }
}

