/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.FileWarnState;
import com.wgcloud.entity.OtherLogInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.OtherLogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.mongo.PageResultDto;
import com.wgcloud.util.mongo.ParamDto;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/otherLogState"})
public class OtherLogController {
    private static final Logger logger = LoggerFactory.getLogger(OtherLogController.class);
    @Autowired
    private OtherLogInfoService otherLogInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String stateList(OtherLogInfo otherLogInfo, Model model, HttpServletRequest request) {
        try {
            String timeRange;
            StringBuffer url = new StringBuffer();
            ArrayList<ParamDto> paramDtoList = new ArrayList<ParamDto>();
            if (!StringUtils.isEmpty((CharSequence)otherLogInfo.getTitle())) {
                url.append("&title=").append(otherLogInfo.getTitle());
                paramDtoList.add(new ParamDto("title", "like", otherLogInfo.getTitle()));
            }
            if (!StringUtils.isEmpty((CharSequence)otherLogInfo.getInfoContent())) {
                url.append("&infoContent=").append(otherLogInfo.getInfoContent());
                paramDtoList.add(new ParamDto("infoContent", "like", otherLogInfo.getInfoContent()));
            }
            if (!StringUtils.isEmpty((CharSequence)(timeRange = request.getParameter("startTime")))) {
                String startTime = timeRange.split(" - ")[0].trim();
                String endTime = timeRange.split(" - ")[1].trim();
                paramDtoList.add(new ParamDto("createTime", "between", startTime + " 00:00:00" + "," + endTime + " 23:59:59"));
                url.append("&startTime=").append(timeRange);
                model.addAttribute("startTime", (Object)timeRange);
            }
            PageResultDto pageInfo = this.otherLogInfoService.selectByParams(paramDtoList, otherLogInfo.getPage().intValue(), otherLogInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageResultDto)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/otherLogState/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("otherLogInfo", (Object)otherLogInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "otherLog/list";
    }

    @RequestMapping(value={"view"})
    public String stateView(OtherLogInfo otherLogInfo, Model model, HttpServletRequest request) {
        try {
            otherLogInfo = this.otherLogInfoService.selectById(otherLogInfo.getId());
            model.addAttribute("otherLogInfo", (Object)otherLogInfo);
            model.addAttribute("otherLogInfoIds", (Object)otherLogInfo.getId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u91c7\u96c6\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u65e5\u5fd7\u91c7\u96c6\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", e.toString(), "2");
        }
        return "otherLog/view";
    }

    @RequestMapping(value={"viewMany"})
    public String viewMany(FileWarnState fileWarnState, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                List list = this.otherLogInfoService.selectByIdArray(request.getParameter("id"));
                OtherLogInfo otherLogInfoResult = (OtherLogInfo)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    otherLogInfoResult.setInfoContent(((OtherLogInfo)list.get(i)).getInfoContent() + otherLogInfoResult.getInfoContent());
                }
                model.addAttribute("otherLogInfo", (Object)otherLogInfoResult);
            }
            model.addAttribute("otherLogInfoIds", (Object)request.getParameter("id"));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u91c7\u96c6\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u65e5\u5fd7\u91c7\u96c6\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", e.toString(), "2");
        }
        return "otherLog/view";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportLog"})
    public void exportTxt(HttpServletResponse response, HttpServletRequest request) {
        FilterOutputStream buff = null;
        ServletOutputStream outStr = null;
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar();
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/plain");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName + ".log");
            String otherLogInfoIds = request.getParameter("otherLogInfoIds");
            OtherLogInfo otherLogInfoResult = new OtherLogInfo();
            if (!StringUtils.isEmpty((CharSequence)otherLogInfoIds)) {
                List list = this.otherLogInfoService.selectByIdArray(otherLogInfoIds);
                otherLogInfoResult = (OtherLogInfo)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    otherLogInfoResult.setInfoContent(((OtherLogInfo)list.get(i)).getInfoContent() + "</br>" + otherLogInfoResult.getInfoContent());
                }
            }
            otherLogInfoResult.setInfoContent(otherLogInfoResult.getInfoContent().replaceAll("</br>", "\n"));
            outStr = response.getOutputStream();
            buff = new BufferedOutputStream((OutputStream)outStr);
            buff.write(otherLogInfoResult.getInfoContent().getBytes("UTF-8"));
            ((BufferedOutputStream)buff).flush();
            buff.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (buff != null) {
                    buff.close();
                }
                if (outStr != null) {
                    outStr.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6d41\u5bf9\u8c61\u51fa\u9519", (Throwable)e);
            }
        }
    }
}

