/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.dto.MessageDto;
import com.wgcloud.dto.SubtitleDto;
import com.wgcloud.entity.LogSizeInfo;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.mongo.MongoBaseService;
import com.wgcloud.util.mongo.MongodbToolUtil;
import com.wgcloud.util.mongo.PageQueryDto;
import com.wgcloud.util.mongo.PageResultDto;
import com.wgcloud.util.staticvar.StaticKeys;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class LogSizeInfoService {
    private static final Logger logger = LoggerFactory.getLogger(LogSizeInfoService.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoBaseService mongoBaseService;

    public List<LogSizeInfo> selectAllByParams(String orderName, String orderRules) {
        try {
            Query query = new Query();
            if ("ASC".equals(orderRules)) {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)orderName)}));
            }
            if ("DESC".equals(orderRules)) {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)orderName)}));
            }
            return this.mongoBaseService.listByQuery(query, (Object)new LogSizeInfo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return new ArrayList<LogSizeInfo>();
        }
    }

    public List<LogSizeInfo> selectAllByParams(Query query) {
        try {
            return this.mongoBaseService.listByQuery(query, (Object)new LogSizeInfo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return new ArrayList<LogSizeInfo>();
        }
    }

    public PageResultDto selectByParams(List paramDtoList, int currPage, int pageSize) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(pageSize));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(currPage));
        pageQueryDto.setParams(paramDtoList);
        PageResultDto result = MongodbToolUtil.selectByParams((PageQueryDto)pageQueryDto, LogSizeInfo.class, (MongoTemplate)this.mongoTemplate, (String)"_id", (String)"DESC");
        return result;
    }

    public void save(String todayLogSize) {
        LogSizeInfo logSizeInfo = new LogSizeInfo();
        logSizeInfo.setTodayLogSize(todayLogSize);
        logSizeInfo.setId(UUIDUtil.getUUID());
        logSizeInfo.setTodayDate(DateUtil.getCurrentDate());
        logSizeInfo.setCreateTime(new Date());
        try {
            this.mongoBaseService.save((Object)logSizeInfo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u65e5\u5fd7\u91c7\u96c6\u5927\u5c0f\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    public void update(LogSizeInfo logSizeInfo) throws Exception {
        this.mongoBaseService.update((Object)logSizeInfo, logSizeInfo.getId());
    }

    public String addLogSize(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "0B";
        }
        try {
            Integer bodyBytes = str.getBytes(StandardCharsets.UTF_8).length;
            StaticKeys.LOG_SIZE_CACHE = StaticKeys.LOG_SIZE_CACHE + (long)bodyBytes.intValue();
            StaticKeys.LOG_GATHER_COUNT_CACHE = StaticKeys.LOG_GATHER_COUNT_CACHE + 1;
            String bodySize = FormatUtil.bytesFormatUnit((String)String.valueOf(bodyBytes), (String)"byte");
            return bodySize;
        }
        catch (Exception e) {
            logger.error("addLogSize\u9519\u8bef", (Throwable)e);
            return "0B";
        }
    }

    public LogSizeInfo selectById(String id) throws Exception {
        return (LogSizeInfo)this.mongoTemplate.findById((Object)id, LogSizeInfo.class);
    }

    public void setSubtitle(Model model, List<LogSizeInfo> logSizeInfoList) {
        Double maxLogSize = 0.0;
        Double minLogSize = 10000.0;
        Double avgLogSize = 0.0;
        Double sumLogSize = 0.0;
        Integer maxLogCount = 0;
        Integer minLogCount = 10000;
        Double avgLogCount = 0.0;
        Integer sumLogCount = 0;
        for (LogSizeInfo logSizeInfo : logSizeInfoList) {
            if (StringUtils.isEmpty((CharSequence)logSizeInfo.getTodayLogSize())) continue;
            Double todayLogSize = Double.valueOf(logSizeInfo.getTodayLogSize()) / 1024.0 / 1024.0;
            logSizeInfo.setTodayLogSize(FormatUtil.formatDouble((Double)todayLogSize, (int)1) + "");
            logSizeInfo.setTodayLogSizeDouble(Double.valueOf(FormatUtil.formatDouble((Double)todayLogSize, (int)1)));
            if (!StringUtils.isEmpty((CharSequence)logSizeInfo.getTodayLogSize())) {
                sumLogSize = sumLogSize + todayLogSize;
            }
            if (todayLogSize > maxLogSize) {
                maxLogSize = todayLogSize;
            }
            if (todayLogSize < minLogSize) {
                minLogSize = todayLogSize;
            }
            if (null == logSizeInfo.getTodayLogCount()) continue;
            sumLogCount = sumLogCount + logSizeInfo.getTodayLogCount();
            if (logSizeInfo.getTodayLogCount() > maxLogCount) {
                maxLogCount = logSizeInfo.getTodayLogCount();
            }
            if (logSizeInfo.getTodayLogCount() >= minLogCount) continue;
            minLogCount = logSizeInfo.getTodayLogCount();
        }
        if (logSizeInfoList.size() > 0) {
            avgLogSize = sumLogSize / (double)logSizeInfoList.size();
            avgLogCount = (double)sumLogCount.intValue() / (double)logSizeInfoList.size();
        } else {
            minLogSize = 0.0;
        }
        model.addAttribute("logSizeSumGB", (Object)(FormatUtil.formatDouble((Double)(sumLogSize / 1024.0), (int)2) + "G"));
        SubtitleDto hostDiskPerSubtitleDto = new SubtitleDto();
        hostDiskPerSubtitleDto.setAvgValue(FormatUtil.formatDouble((Double)avgLogSize, (int)2) + "MB");
        hostDiskPerSubtitleDto.setMaxValue(FormatUtil.formatDouble((Double)maxLogSize, (int)2) + "MB");
        hostDiskPerSubtitleDto.setMinValue(FormatUtil.formatDouble((Double)minLogSize, (int)2) + "MB");
        model.addAttribute("logSizeSubtitleDto", (Object)hostDiskPerSubtitleDto);
        SubtitleDto countSubtitleDto = new SubtitleDto();
        countSubtitleDto.setAvgValue(FormatUtil.formatDouble((Double)avgLogCount, (int)2) + "\u6b21");
        countSubtitleDto.setMaxValue(maxLogCount + "\u6b21");
        countSubtitleDto.setMinValue(minLogCount + "\u6b21");
        model.addAttribute("countSubtitleDto", (Object)countSubtitleDto);
        model.addAttribute("logSizeSumCount", (Object)(sumLogCount + "\u6b21"));
    }

    public void setDateParam(String am, Map<String, Object> params, Model model) {
        if ("null".equals(am)) {
            am = "";
        }
        try {
            String nowTime = DateUtil.getCurrentDateTime();
            if (!StringUtils.isEmpty((CharSequence)am)) {
                if ("am1".equals(am)) {
                    params.put("startTime", DateUtil.getDateBefore((int)7));
                    params.put("endTime", nowTime);
                }
                if ("am2".equals(am)) {
                    params.put("startTime", DateUtil.getDateBefore((int)15));
                    params.put("endTime", nowTime);
                }
                if ("am3".equals(am)) {
                    params.put("startTime", DateUtil.getDateBefore((int)20));
                    params.put("endTime", nowTime);
                }
                if ("am4".equals(am)) {
                    params.put("startTime", DateUtil.getDateBefore((int)30));
                    params.put("endTime", nowTime);
                }
                if ("am5".equals(am)) {
                    params.put("startTime", DateUtil.getDateBefore((int)60));
                    params.put("endTime", nowTime);
                }
                if ("am6".equals(am)) {
                    params.put("startTime", DateUtil.getDateBefore((int)90));
                    params.put("endTime", nowTime);
                }
                if ("am7".equals(am)) {
                    // empty if block
                }
                model.addAttribute("am", (Object)am);
                return;
            }
            params.put("startTime", DateUtil.getDateBefore((int)7));
            params.put("endTime", nowTime);
            model.addAttribute("am", (Object)"am1");
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u91c7\u96c6\u65e5\u5fd7\u7684\u5386\u53f2\u5927\u5c0f\u56fe\u8868\u7ec4\u88c5\u65e5\u671f\u67e5\u8be2\u6761\u4ef6\u9519\u8bef", (Throwable)e);
        }
    }

    public List<MessageDto> getDayListParam() {
        MessageDto dto1 = new MessageDto();
        dto1.setCode("am1");
        dto1.setMsg("\u6700\u8fd17\u5929");
        MessageDto dto2 = new MessageDto();
        dto2.setCode("am2");
        dto2.setMsg("\u6700\u8fd115\u5929");
        MessageDto dto3 = new MessageDto();
        dto3.setCode("am3");
        dto3.setMsg("\u6700\u8fd120\u5929");
        MessageDto dto4 = new MessageDto();
        dto4.setCode("am4");
        dto4.setMsg("\u6700\u8fd130\u5929");
        MessageDto dto5 = new MessageDto();
        dto5.setCode("am5");
        dto5.setMsg("\u6700\u8fd160\u5929");
        MessageDto dto6 = new MessageDto();
        dto6.setCode("am6");
        dto6.setMsg("\u6700\u8fd190\u5929");
        MessageDto dto7 = new MessageDto();
        dto7.setCode("am7");
        dto7.setMsg("ALL");
        ArrayList<MessageDto> timeList = new ArrayList<MessageDto>();
        timeList.add(dto1);
        timeList.add(dto2);
        timeList.add(dto3);
        timeList.add(dto4);
        timeList.add(dto5);
        timeList.add(dto6);
        timeList.add(dto7);
        return timeList;
    }
}

