/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.mongo;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.wgcloud.util.mongo.MongodbToolUtil;
import com.wgcloud.util.mongo.PageQueryDto;
import com.wgcloud.util.mongo.PageResultDto;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class MongoBaseService<T, ID> {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoClient mongoClient;

    public <S extends T> S save(S entity) {
        try {
            return (S)this.mongoTemplate.save(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <S extends T> DeleteResult deleteById(S s, ID id) {
        try {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(id));
            return this.mongoTemplate.remove(query, s.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <S extends T> DeleteResult deleteByIds(S s, List<ID> ids) {
        try {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
            return this.mongoTemplate.remove(query, s.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <S extends T> UpdateResult update(S s, String id) {
        ClientSession clientSession = this.mongoClient.startSession();
        try {
            Field[] fields;
            clientSession.startTransaction();
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
            Update update = new Update();
            for (Field field : fields = s.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String name = field.getName();
                if ("serialVersionUID".equals(name)) continue;
                Object value = field.get(s);
                if (!ObjectUtils.allNotNull((Object[])new Object[]{value})) continue;
                update.set(name, value);
            }
            return this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, s.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <S extends T> UpdateResult updateByQuery(S s, Query query, Update update) {
        try {
            return this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, s.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <S extends T> PageResultDto selectByParams(PageQueryDto dto, S s, String orderName, String orderRules) {
        return MongodbToolUtil.selectByParams((PageQueryDto)dto, s.getClass(), (MongoTemplate)this.mongoTemplate, (String)orderName, (String)orderRules);
    }

    public <S extends T> S getInfoById(ID id, S s) {
        return (S)this.mongoTemplate.findById(id, s.getClass());
    }

    public <S extends T> List<S> getInfoByIds(List<ID> ids, S s) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        return this.mongoTemplate.find(query, s.getClass());
    }

    public <S extends T> List<S> listByQuery(Query query, S s) {
        if (null != query) {
            return this.mongoTemplate.find(query, s.getClass());
        }
        return this.mongoTemplate.findAll(s.getClass());
    }
}

