/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.entity.FileWarnState;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.entity.OtherLogInfo;
import com.wgcloud.service.DangerLogInfoService;
import com.wgcloud.service.FileWarnInfoService;
import com.wgcloud.service.FileWarnStateService;
import com.wgcloud.service.HostInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.LogSizeInfoService;
import com.wgcloud.service.OtherLogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.IpUtil;
import com.wgcloud.util.MessageErrorUtils;
import com.wgcloud.util.ResDataUtils;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.msg.WarnOtherUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/agentLogGo"})
public class AgentLogGoController {
    private static final Logger logger = LoggerFactory.getLogger(AgentLogGoController.class);
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private FileWarnInfoService fileWarnInfoService;
    @Autowired
    private FileWarnStateService fileWarnStateService;
    @Autowired
    private HostInfoService hostInfoService;
    @Autowired
    private OtherLogInfoService otherLogInfoService;
    @Autowired
    private DangerLogInfoService dangerLogInfoService;
    @Autowired
    private LogSizeInfoService logSizeInfoService;
    @Autowired
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private MessageErrorUtils messageErrorUtils;

    @ResponseBody
    @RequestMapping(value={"/minTask"})
    public JSONObject minTask(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        logger.debug("agent\u4e0a\u62a5\u65e5\u5fd7\u76d1\u63a7\u6570\u636e-------------" + agentJsonObject.toString());
        JSONObject resultJson = new JSONObject();
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("Token is error");
            resultJson.set("result", (Object)"Token is error");
            return resultJson;
        }
        Date nowTime = new Date();
        try {
            JSONObject fileWarnInfosJson = agentJsonObject.getJSONObject((Object)"fileWarnInfos");
            if (fileWarnInfosJson == null) {
                logger.error("fileWarnList is null");
                resultJson.set("result", (Object)"error\uff1afileWarnList is null");
                return resultJson;
            }
            for (String id : fileWarnInfosJson.keySet()) {
                JSONObject jsonObject = fileWarnInfosJson.getJSONObject((Object)id);
                String filePath = jsonObject.getStr((Object)"filePath");
                String fileSize = jsonObject.getStr((Object)"fileSize");
                String fileTotalNum = jsonObject.getStr((Object)"fileTotalNum");
                String startRows = jsonObject.getStr((Object)"startRows");
                String warnRows = jsonObject.getStr((Object)"warnRows");
                String warnContent = jsonObject.getStr((Object)"warnContent");
                String gatherLogContent = jsonObject.getStr((Object)"gatherLogContent");
                String nameSpace = jsonObject.getStr((Object)"nameSpace");
                FileWarnState state = new FileWarnState();
                state.setCreateTime(nowTime);
                state.setFilePath(filePath);
                state.setFileWarnId(id);
                state.setGatherLogContent(gatherLogContent);
                state.setStartRows(startRows);
                state.setWarnRows(warnRows);
                String logSize = this.logSizeInfoService.addLogSize(gatherLogContent);
                state.setLogSize(logSize);
                if (!StringUtils.isEmpty((CharSequence)gatherLogContent)) {
                    if (StringUtils.isEmpty((CharSequence)nameSpace)) {
                        this.fileWarnStateService.save(state);
                    } else {
                        this.fileWarnStateService.save(state, nameSpace);
                    }
                }
                FileWarnInfo info = new FileWarnInfo();
                info.setId(id);
                info.setCreateTime(nowTime);
                info.setFileSize(fileSize);
                info.setWarnRows(warnRows);
                info.setFileTotalNum(fileTotalNum);
                this.fileWarnInfoService.updateById(info);
                if (StringUtils.isEmpty((CharSequence)warnContent)) continue;
                Runnable runnable = () -> {
                    try {
                        FileWarnInfo fileWarnInfo = this.fileWarnInfoService.selectById(info.getId());
                        if (fileWarnInfo != null) {
                            WarnOtherUtil.sendFileWarnDown((FileWarnInfo)fileWarnInfo, (String)filePath, (String)warnContent, (boolean)true);
                            this.dangerLogInfoService.save(fileWarnInfo.getHostname(), filePath, warnContent, fileWarnInfo.getWarnChars(), fileWarnInfo.getRemark());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                };
                ThreadPoolUtil.executor.execute(runnable);
            }
            resultJson.set("result", (Object)"success");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u65e5\u5fd7\u76d1\u63a7\u4e0a\u62a5\u6570\u636e\u9519\u8bef", (Throwable)e);
            resultJson.set("result", (Object)("error: " + e.toString()));
        }
        return resultJson;
    }

    @ResponseBody
    @RequestMapping(value={"/gatherBindIp"})
    public JSONObject gatherBindIp(@RequestBody String paramBean, HttpServletRequest request) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        logger.debug("agent\u4e0a\u62a5\u4e3b\u673a\u7684bindIp\u6570\u636e-------------" + agentJsonObject.toString());
        JSONObject resultJson = new JSONObject();
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("Token is error");
            resultJson.set("result", (Object)"Token is error");
            return resultJson;
        }
        String bindIp = agentJsonObject.getStr((Object)"bindIp");
        String agentVer = agentJsonObject.getStr((Object)"agentVer");
        String platForm = agentJsonObject.getStr((Object)"platForm");
        String submitSeconds = agentJsonObject.getStr((Object)"submitSeconds");
        String maxLogRows = agentJsonObject.getStr((Object)"maxLogRows");
        String nameSpace = agentJsonObject.getStr((Object)"nameSpace");
        if (!StringUtils.isEmpty((CharSequence)bindIp)) {
            List hostInfoList = this.hostInfoService.selectAllByParams();
            boolean isExist = false;
            HostInfo hostInfo = new HostInfo();
            for (HostInfo hostInfoTmp : hostInfoList) {
                if (!hostInfoTmp.getHostname().equals(bindIp)) continue;
                isExist = true;
                hostInfo.setId(hostInfoTmp.getId());
                break;
            }
            hostInfo.setHostname(bindIp);
            hostInfo.setAgentVer(agentVer);
            hostInfo.setPlatForm(platForm);
            hostInfo.setSubmitSeconds(submitSeconds);
            hostInfo.setMaxLogRows(maxLogRows);
            hostInfo.setNameSpace(nameSpace);
            hostInfo.setState("1");
            if (!isExist) {
                this.hostInfoService.save(hostInfo);
            } else {
                hostInfo.setCreateTime(new Date());
                this.hostInfoService.updateById(hostInfo);
            }
        } else {
            logger.error("\u4e3b\u673a\u4e0a\u62a5\u7684bindIp\u4e3a\u7a7a------------" + IpUtil.getIpAddr((HttpServletRequest)request));
        }
        resultJson.set("result", (Object)"success");
        return resultJson;
    }

    @ResponseBody
    @RequestMapping(value={"agentList"})
    public String agentList(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("Token is error");
            return ResDataUtils.resetErrorJson((String)"Token is error");
        }
        if (!this.tokenUtils.checkAllowOpenData(agentJsonObject)) {
            logger.error("Missing require parameters");
            return ResDataUtils.resetErrorJson((String)"Missing require parameters");
        }
        if (null == agentJsonObject.get((Object)"hostname") || StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"hostname").toString())) {
            return "";
        }
        String hostname = agentJsonObject.get((Object)"hostname").toString();
        try {
            List fileWarnInfoList = this.fileWarnInfoService.selectAllByParams(hostname, "1");
            String cmdSplitChar = " && ";
            String blockKey = "";
            ArrayList<FileWarnInfo> fileWarnListResult = new ArrayList<FileWarnInfo>();
            for (FileWarnInfo fileWarnInfo : fileWarnInfoList) {
                if (StringUtils.isEmpty((CharSequence)fileWarnInfo.getCustomShell())) {
                    fileWarnInfo.setCustomShell("");
                }
                if (!StringUtils.isEmpty((CharSequence)(blockKey = FormatUtil.haveBlockDanger((String)fileWarnInfo.getCustomShell(), (String)this.commonConfig.getShellToRunBlock())))) {
                    logger.error(fileWarnInfo.getCustomShell() + "\u65e5\u5fd7\u76d1\u63a7\u5904\u7406\u6307\u4ee4\u542b\u6709\u654f\u611f\u5b57\u7b26" + blockKey + "\uff0c\u4e0d\u8fdb\u884c\u4e0b\u53d1");
                    continue;
                }
                fileWarnInfo.setCustomShell(fileWarnInfo.getCustomShell().replaceAll("\\r\\n", cmdSplitChar));
                fileWarnListResult.add(fileWarnInfo);
            }
            return ResDataUtils.resetSuccessJson(fileWarnListResult);
        }
        catch (Exception e) {
            logger.error("agent\u83b7\u53d6\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("agent\u83b7\u53d6\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
    }

    @ResponseBody
    @RequestMapping(value={"commonLogHandle"})
    public String agentCommonWarnHandle(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        String checkResult = this.tokenUtils.preOpenDataAPICheck(agentJsonObject);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            return checkResult;
        }
        try {
            String title = "\u3010\u7b2c\u4e09\u65b9\u63d0\u4ea4\u3011\u65e5\u5fd7\u63a5\u53e3";
            OtherLogInfo otherLogInfo = new OtherLogInfo();
            if (null != agentJsonObject.get((Object)"title") && !StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"title").toString())) {
                title = agentJsonObject.get((Object)"title").toString();
                otherLogInfo.setTitle(title);
            }
            String remark = "";
            if (null != agentJsonObject.get((Object)"remark") && !StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"remark").toString())) {
                remark = agentJsonObject.get((Object)"remark").toString();
                otherLogInfo.setRemark(remark);
            }
            String content = "";
            if (null != agentJsonObject.get((Object)"content") && !StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"content").toString())) {
                content = agentJsonObject.get((Object)"content").toString();
                otherLogInfo.setInfoContent(content);
            }
            String logSize = this.logSizeInfoService.addLogSize(content);
            otherLogInfo.setLogSize(logSize);
            this.otherLogInfoService.save(otherLogInfo);
            return ResDataUtils.resetSuccessJson((Object)"success");
        }
        catch (Exception e) {
            logger.error("\u516c\u5171\u65e5\u5fd7\u63a5\u53e3\u9519\u8bef", (Throwable)e);
            return ResDataUtils.resetErrorJson((String)e.toString());
        }
    }

    @ResponseBody
    @RequestMapping(value={"/execShellDownMsgForAgent"})
    public JSONObject execShellDownMsgForAgent(@RequestBody String paramBean, HttpServletRequest request) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        logger.debug("agent\u4e0a\u62a5\u6210\u529f\u6267\u884c\u65e5\u5fd7\u544a\u8b66\u7684\u81ea\u5b9a\u4e49\u5904\u7406\u6307\u4ee4-------------" + agentJsonObject.toString());
        JSONObject resultJson = new JSONObject();
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("Token is error");
            resultJson.set("result", (Object)"Token is error");
            return resultJson;
        }
        String fileWarnInfoId = agentJsonObject.getStr((Object)"fileWarnInfoId");
        String filePath = agentJsonObject.getStr((Object)"filePath");
        String state = agentJsonObject.getStr((Object)"state");
        try {
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfoId)) {
                FileWarnInfo fileWarnInfo = this.fileWarnInfoService.selectById(fileWarnInfoId);
                if (null != fileWarnInfo) {
                    String key = fileWarnInfoId + "_CallBackMsg";
                    if (!StringUtils.isEmpty((CharSequence)state)) {
                        this.messageErrorUtils.setErrorMsgHandler(key, DateUtil.getCurrentDateTime() + " " + state);
                    }
                    Runnable runnable = () -> {
                        try {
                            if (fileWarnInfo != null) {
                                String fileRemark = "";
                                if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getRemark())) {
                                    fileRemark = fileWarnInfo.getRemark();
                                }
                                String title = "\u65e5\u5fd7\u544a\u8b66\u81ea\u52a8\u5904\u7406\u6307\u4ee4\u5df2\u6267\u884c\u5b8c\u6210\uff1a" + fileWarnInfo.getHostname();
                                String commContent = "\u65e5\u5fd7\u544a\u8b66\u81ea\u52a8\u5904\u7406\u6307\u4ee4\u5df2\u6267\u884c\u5b8c\u6210\uff1a" + fileWarnInfo.getHostname() + "\uff0c\u65e5\u5fd7\u5907\u6ce8\uff1a" + fileRemark + "\uff0c\u65e5\u5fd7\u6587\u4ef6\uff1a" + filePath;
                                WarnOtherUtil.sendUtil((String)title, (String)commContent);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    };
                    ThreadPoolUtil.executor.execute(runnable);
                }
            } else {
                logger.error("\u4e3b\u673a\u4e0a\u62a5\u7684bindIp\u4e3a\u7a7a------------" + IpUtil.getIpAddr((HttpServletRequest)request));
            }
        }
        catch (Exception e) {
            logger.error("agent\u4e0a\u62a5\u6210\u529f\u6267\u884c\u65e5\u5fd7\u544a\u8b66\u7684\u81ea\u5b9a\u4e49\u5904\u7406\u6307\u4ee4\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("agent\u4e0a\u62a5\u6210\u529f\u6267\u884c\u65e5\u5fd7\u544a\u8b66\u7684\u81ea\u5b9a\u4e49\u5904\u7406\u6307\u4ee4\u606f\u9519\u8bef", e.toString(), "2");
        }
        resultJson.set("result", (Object)"success");
        return resultJson;
    }
}

