/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.DangerLogInfo;
import com.wgcloud.service.DangerLogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.mongo.PageResultDto;
import com.wgcloud.util.mongo.ParamDto;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/dangerLog"})
public class DangerLogInfoController {
    private static final Logger logger = LoggerFactory.getLogger(DangerLogInfoController.class);
    @Resource
    private DangerLogInfoService dangerLogInfoService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String LogInfoList(DangerLogInfo dangerLogInfo, Model model, HttpServletRequest request) {
        try {
            StringBuffer url = new StringBuffer();
            ArrayList<ParamDto> paramDtoList = new ArrayList<ParamDto>();
            String timeRange = request.getParameter("startTime");
            if (!StringUtils.isEmpty((CharSequence)dangerLogInfo.getLogFileName())) {
                url.append("&logFileName=").append(dangerLogInfo.getLogFileName());
                paramDtoList.add(new ParamDto("logFileName", "like", dangerLogInfo.getLogFileName().trim()));
            }
            if (!StringUtils.isEmpty((CharSequence)dangerLogInfo.getInfoContent())) {
                url.append("&infoContent=").append(dangerLogInfo.getInfoContent());
                paramDtoList.add(new ParamDto("infoContent", "like", dangerLogInfo.getInfoContent().trim()));
            }
            if (!StringUtils.isEmpty((CharSequence)dangerLogInfo.getHostname())) {
                url.append("&hostname=").append(dangerLogInfo.getHostname());
                paramDtoList.add(new ParamDto("hostname", "like", dangerLogInfo.getHostname().trim()));
            }
            if (!StringUtils.isEmpty((CharSequence)timeRange)) {
                String startTime = timeRange.split(" - ")[0].trim();
                String endTime = timeRange.split(" - ")[1].trim();
                paramDtoList.add(new ParamDto("createTime", "between", startTime + " 00:00:00" + "," + endTime + " 23:59:59"));
                url.append("&startTime=").append(timeRange);
                model.addAttribute("startTime", (Object)timeRange);
            }
            PageResultDto pageInfo = this.dangerLogInfoService.selectByParams(paramDtoList, dangerLogInfo.getPage().intValue(), dangerLogInfo.getPageSize().intValue());
            for (DangerLogInfo dangerLogInfo1 : pageInfo.getList()) {
                dangerLogInfo1.setHostname(dangerLogInfo1.getHostname() + HostUtil.addRemark((String)dangerLogInfo1.getHostname()));
            }
            PageUtil.initPageNumber((PageResultDto)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/dangerLog/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("dangerLogInfo", (Object)dangerLogInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u544a\u8b66\u65e5\u5fd7\u5217\u8868\u9519\u8bef", (Throwable)e);
        }
        return "dangerLog/list";
    }

    @RequestMapping(value={"view"})
    public String viewLogInfo(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        DangerLogInfo dangerLogInfo = new DangerLogInfo();
        try {
            dangerLogInfo = this.dangerLogInfoService.selectById(id);
            dangerLogInfo.setHostname(dangerLogInfo.getHostname() + HostUtil.addRemark((String)dangerLogInfo.getHostname()));
            model.addAttribute("dangerLogInfo", (Object)dangerLogInfo);
            model.addAttribute("dangerLogInfoIds", (Object)dangerLogInfo.getId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u544a\u8b66\u65e5\u5fd7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return "dangerLog/view";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportLog"})
    public void exportTxt(HttpServletResponse response, HttpServletRequest request) {
        FilterOutputStream buff = null;
        ServletOutputStream outStr = null;
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                response.setContentType("text/html;charset=UTF-8");
                response.getOutputStream().write("The module needs to professional version. Please contact us at www.wgstart.com".getBytes());
                return;
            }
            String fileName = DateUtil.getCurrentDateTimeNoChar();
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/plain");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName + ".log");
            String fileWarnIds = request.getParameter("fileWarnId");
            DangerLogInfo dangerLogInfoResult = new DangerLogInfo();
            if (!StringUtils.isEmpty((CharSequence)fileWarnIds)) {
                List list = this.dangerLogInfoService.selectByIdArray(fileWarnIds);
                dangerLogInfoResult = (DangerLogInfo)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    dangerLogInfoResult.setInfoContent(((DangerLogInfo)list.get(i)).getInfoContent() + dangerLogInfoResult.getInfoContent());
                }
            }
            dangerLogInfoResult.setInfoContent(dangerLogInfoResult.getInfoContent().replaceAll("</br>", "\n"));
            outStr = response.getOutputStream();
            buff = new BufferedOutputStream((OutputStream)outStr);
            buff.write(dangerLogInfoResult.getInfoContent().getBytes("UTF-8"));
            ((BufferedOutputStream)buff).flush();
            buff.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (buff != null) {
                    buff.close();
                }
                if (outStr != null) {
                    outStr.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6d41\u5bf9\u8c61\u51fa\u9519", (Throwable)e);
            }
        }
    }

    @RequestMapping(value={"viewMany"})
    public String viewMany(Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                List list = this.dangerLogInfoService.selectByIdArray(request.getParameter("id"));
                DangerLogInfo dangerLogInfo = (DangerLogInfo)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    dangerLogInfo.setInfoContent(((DangerLogInfo)list.get(i)).getInfoContent() + dangerLogInfo.getInfoContent());
                }
                model.addAttribute("dangerLogInfo", (Object)dangerLogInfo);
            }
            model.addAttribute("dangerLogInfoIds", (Object)request.getParameter("id"));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u91c7\u96c6\u4fe1\u606f\u8be6\u60c5\u9519\u8bef", (Throwable)e);
        }
        return "dangerLog/view";
    }
}

