/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.entity.LogSizeInfo;
import com.wgcloud.service.FileWarnInfoService;
import com.wgcloud.service.FileWarnStateService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.LogSizeInfoService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/dash"})
public class DashboardController {
    private static final Logger logger = LoggerFactory.getLogger(DashboardController.class);
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private FileWarnInfoService fileWarnInfoService;
    @Resource
    private FileWarnStateService fileWarnStateService;
    @Autowired
    private LogSizeInfoService logSizeInfoService;
    @Autowired
    CommonConfig commonConfig;
    @Autowired
    private MongoTemplate mongoTemplate;

    @RequestMapping(value={"main"})
    public String mainList(Model model, HttpServletRequest request) {
        try {
            ArrayList paramList = new ArrayList();
            List fileList = this.fileWarnInfoService.selectAllByParams();
            model.addAttribute("fileWarnSize", (Object)fileList.size());
            String sumSize = this.sumLogFileSize(fileList);
            model.addAttribute("fileWarnSumSize", (Object)sumSize);
            String sumRows = this.sumLogFileRows(fileList);
            model.addAttribute("fileWarnSumRows", (Object)sumRows);
            this.sumHostNum(model);
            Integer logFileSize = this.sumFileTypeSize(fileList, "1");
            model.addAttribute("logFileSize", (Object)logFileSize);
            Integer outFileSize = this.sumFileTypeSize(fileList, "3");
            model.addAttribute("outFileSize", (Object)outFileSize);
            Integer txtFileSize = this.sumFileTypeSize(fileList, "2");
            model.addAttribute("txtFileSize", (Object)txtFileSize);
            Integer logOtherSize = this.sumFileTypeSize(fileList, "");
            model.addAttribute("logOtherSize", (Object)logOtherSize);
            Integer fileTotalNum = this.sumLogFileNumForHistory(fileList);
            model.addAttribute("fileTotalNum", (Object)fileTotalNum);
            model.addAttribute("pwdExpDateShow", (Object)this.commonConfig.getPwdExpDate());
            model.addAttribute("historyDataOut", (Object)this.commonConfig.getHistoryDataOut());
            this.handleHostInfo(model);
            this.applicationDataInfo(model);
            this.showLastLogSize(model);
            LicenseUtil.outDateAlter((Model)model, (int)StaticKeys.HOST_INFO_LIST.size());
        }
        catch (Exception e) {
            logger.error("\u65e5\u5fd7\u6982\u8981\u9875\u9762\u4fe1\u606f\u5c55\u793a\u9519\u8bef", (Throwable)e);
        }
        return "index";
    }

    private String sumLogFileSize(List<FileWarnInfo> fileList) {
        Long sumSize = 0L;
        for (FileWarnInfo fileWarnInfo : fileList) {
            try {
                if (StringUtils.isEmpty((CharSequence)fileWarnInfo.getFileSize()) || "0".equals(fileWarnInfo.getFileSize())) continue;
                String fileSize = "";
                fileSize = fileWarnInfo.getFileSize().indexOf(".") > -1 ? fileWarnInfo.getFileSize().substring(0, fileWarnInfo.getFileSize().indexOf(".")) : fileWarnInfo.getFileSize();
                sumSize = sumSize + Long.valueOf(fileSize);
            }
            catch (Exception e) {
                logger.error("\u8ba1\u7b97\u6240\u6709\u65e5\u5fd7\u6587\u4ef6\u5927\u5c0f\u603b\u548c\u9519\u8bef", (Throwable)e);
            }
        }
        String fileFormatSize = FormatUtil.bytesFormatUnit((String)(sumSize + ""), (String)"byte");
        return fileFormatSize;
    }

    private String sumLogFileRows(List<FileWarnInfo> fileList) {
        Long sumSize = 0L;
        for (FileWarnInfo fileWarnInfo : fileList) {
            try {
                if (StringUtils.isEmpty((CharSequence)fileWarnInfo.getWarnRows()) || "0".equals(fileWarnInfo.getWarnRows())) continue;
                sumSize = sumSize + Long.valueOf(fileWarnInfo.getWarnRows());
            }
            catch (Exception e) {
                logger.error("\u8ba1\u7b97\u6240\u6709\u65e5\u5fd7\u6587\u4ef6\u603b\u884c\u6570\u9519\u8bef", (Throwable)e);
            }
        }
        String fileFormatSize = FormatUtil.numToWStr((Long)sumSize);
        return fileFormatSize;
    }

    private void sumHostNum(Model model) {
        try {
            Integer sumDownSize = 0;
            for (HostInfo hostInfo : StaticKeys.HOST_INFO_LIST) {
                if (!"2".equals(hostInfo.getState())) continue;
                sumDownSize = sumDownSize + 1;
            }
            model.addAttribute("hostSize", (Object)StaticKeys.HOST_INFO_LIST.size());
            model.addAttribute("hostDownSize", (Object)sumDownSize);
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u6240\u6709\u4e3b\u673a\u6570\u91cf\u9519\u8bef", (Throwable)e);
        }
    }

    private Integer sumFileTypeSize(List<FileWarnInfo> fileList, String fileType) {
        Integer sumSize = 0;
        String logTypeList = "4,5,6";
        try {
            for (FileWarnInfo fileWarnInfo : fileList) {
                if (StringUtils.isEmpty((CharSequence)fileType)) {
                    if (!logTypeList.contains(fileWarnInfo.getFileType())) continue;
                    sumSize = sumSize + 1;
                    continue;
                }
                if (!fileType.equals(fileWarnInfo.getFileType())) continue;
                sumSize = sumSize + 1;
            }
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u6240\u6709\u65e5\u5fd7\u6587\u4ef6\u6570\u91cf\u9519\u8bef", (Throwable)e);
        }
        return sumSize;
    }

    private Integer sumLogFileNumForHistory(List<FileWarnInfo> fileList) {
        Integer sumSize = 0;
        for (FileWarnInfo fileWarnInfo : fileList) {
            try {
                if (StringUtils.isEmpty((CharSequence)fileWarnInfo.getWarnRows()) || "0".equals(fileWarnInfo.getWarnRows())) continue;
                sumSize = sumSize + Integer.valueOf(fileWarnInfo.getFileTotalNum());
            }
            catch (Exception e) {
                logger.error("\u8ba1\u7b97\u6240\u6709\u5386\u53f2\u65e5\u5fd7\u6587\u4ef6\u7684\u6570\u91cf\u9519\u8bef", (Throwable)e);
            }
        }
        return sumSize;
    }

    private void handleHostInfo(Model model) {
        try {
            Integer sumSubmitTime = 0;
            double avgSubmitTime = 300.0;
            Integer sumMaxLogRows = 0;
            double avgMaxLogRows = 2000.0;
            for (HostInfo hostInfo : StaticKeys.HOST_INFO_LIST) {
                sumSubmitTime = sumSubmitTime + Integer.valueOf(hostInfo.getSubmitSeconds());
                sumMaxLogRows = sumMaxLogRows + Integer.valueOf(hostInfo.getMaxLogRows());
            }
            if (StaticKeys.HOST_INFO_LIST.size() > 0) {
                avgSubmitTime = (double)sumSubmitTime.intValue() / (double)StaticKeys.HOST_INFO_LIST.size();
                avgMaxLogRows = (double)sumMaxLogRows.intValue() / (double)StaticKeys.HOST_INFO_LIST.size();
            }
            model.addAttribute("avgSubmitTime", (Object)(FormatUtil.formatDouble((Double)avgSubmitTime, (int)2) + "s"));
            model.addAttribute("avgMaxLogRows", (Object)FormatUtil.formatDouble((Double)avgMaxLogRows, (int)2));
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u6240\u6709\u76d1\u63a7\u4e3b\u673a\u7684\u5e73\u5747\u503c\u9519\u8bef", (Throwable)e);
        }
    }

    private void showLastLogSize(Model model) {
        try {
            List list = this.logSizeInfoService.selectAllByParams("_id", "DESC");
            if (!CollectionUtil.isEmpty((Collection)list)) {
                String todayLogSize = FormatUtil.bytesFormatUnit((String)((LogSizeInfo)list.get(0)).getTodayLogSize(), (String)"byte");
                model.addAttribute("todayLogSize", (Object)todayLogSize);
                if (null != ((LogSizeInfo)list.get(0)).getTodayLogCount()) {
                    model.addAttribute("todayLogCount", (Object)((LogSizeInfo)list.get(0)).getTodayLogCount());
                } else {
                    model.addAttribute("todayLogCount", (Object)0);
                }
            } else {
                model.addAttribute("todayLogSize", (Object)"0KB");
                model.addAttribute("todayLogCount", (Object)0);
            }
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u6240\u6709\u65e5\u5fd7\u6587\u4ef6\u5927\u5c0f\u603b\u548c\u9519\u8bef", (Throwable)e);
        }
    }

    private void applicationDataInfo(Model model) {
        try {
            String warnType = "\u672a\u8bbe\u7f6e";
            if (StaticKeys.mailSet != null && !StringUtils.isEmpty((CharSequence)this.commonConfig.getWarnScript())) {
                warnType = "\u90ae\u4ef6+\u811a\u672c";
            }
            if (StaticKeys.mailSet == null && !StringUtils.isEmpty((CharSequence)this.commonConfig.getWarnScript())) {
                warnType = "\u811a\u672c";
            }
            if (StaticKeys.mailSet != null && StringUtils.isEmpty((CharSequence)this.commonConfig.getWarnScript())) {
                warnType = "\u90ae\u4ef6";
            }
            model.addAttribute("warnType", (Object)warnType);
            String openDataAPIVal = "\u5df2\u5173\u95ed";
            if ("true".equals(this.commonConfig.getOpenDataAPI())) {
                openDataAPIVal = "\u5df2\u5f00\u542f";
            }
            model.addAttribute("openDataAPIVal", (Object)openDataAPIVal);
            String adminAccount = "\u9ed8\u8ba4";
            if (!"admin".equals(this.commonConfig.getAccount())) {
                adminAccount = "\u5df2\u4fee\u6539";
            }
            model.addAttribute("adminAccount", (Object)adminAccount);
            String adminPwd = "\u9ed8\u8ba4";
            if (!"111111".equals(this.commonConfig.getAccountPwd())) {
                adminPwd = "\u5df2\u4fee\u6539";
            }
            model.addAttribute("adminPwd", (Object)adminPwd);
            String guestAccount = "\u9ed8\u8ba4";
            if (!"guest".equals(this.commonConfig.getGuestAccount())) {
                guestAccount = "\u5df2\u4fee\u6539";
            }
            model.addAttribute("guestAccount", (Object)guestAccount);
            String guestPwd = "\u9ed8\u8ba4";
            if (!"111111".equals(this.commonConfig.getGuestAccountPwd())) {
                guestPwd = "\u5df2\u4fee\u6539";
            }
            model.addAttribute("guestPwd", (Object)guestPwd);
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u6838\u5fc3\u53c2\u6570\u8bfb\u53d6\u9519\u8bef", (Throwable)e);
        }
    }
}

