/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.service.FileWarnInfoService;
import com.wgcloud.service.FileWarnStateService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.HostUtil;
import com.wgcloud.util.MessageErrorUtils;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.mongo.PageResultDto;
import com.wgcloud.util.mongo.ParamDto;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/fileWarnInfo"})
public class FileWarnInfoController {
    private static final Logger logger = LoggerFactory.getLogger(FileWarnInfoController.class);
    @Resource
    private FileWarnInfoService fileWarnInfoService;
    @Resource
    private FileWarnStateService fileWarnStateService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private TokenUtils tokenUtils;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private MessageErrorUtils messageErrorUtils;

    @RequestMapping(value={"list"})
    public String fileWarnInfoList(FileWarnInfo fileWarnInfo, Model model, HttpServletRequest request) {
        try {
            LicenseUtil.maxLicense_10((Model)model, (HttpServletRequest)request, (Object)fileWarnInfo);
            StringBuffer url = new StringBuffer();
            ArrayList<ParamDto> paramDtoList = new ArrayList<ParamDto>();
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getActive())) {
                url.append("&active=").append(fileWarnInfo.getActive());
                paramDtoList.add(new ParamDto("active", "eq", fileWarnInfo.getActive()));
            }
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getHostname())) {
                url.append("&hostname=").append(fileWarnInfo.getHostname());
                paramDtoList.add(new ParamDto("hostname", "like", fileWarnInfo.getHostname()));
            }
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getFilePath())) {
                url.append("&filePath=").append(fileWarnInfo.getFilePath());
                paramDtoList.add(new ParamDto("filePath", "like", fileWarnInfo.getFilePath()));
            }
            if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getOrderBy())) {
                url.append("&orderBy=").append(fileWarnInfo.getOrderBy());
                url.append("&orderType=").append(fileWarnInfo.getOrderType());
            }
            PageResultDto pageInfo = this.fileWarnInfoService.selectByParams(paramDtoList, fileWarnInfo.getPage().intValue(), fileWarnInfo.getPageSize().intValue(), fileWarnInfo.getOrderBy(), fileWarnInfo.getOrderType());
            for (FileWarnInfo fileWarnInfo1 : pageInfo.getList()) {
                if (!StringUtils.isEmpty((CharSequence)fileWarnInfo1.getFileSize())) {
                    String fileFormatSize = FormatUtil.bytesFormatUnit((String)fileWarnInfo1.getFileSize(), (String)"byte");
                    fileWarnInfo1.setFileSize(fileFormatSize);
                }
                for (HostInfo hostInfo : StaticKeys.HOST_INFO_LIST) {
                    if (!hostInfo.getHostname().equals(fileWarnInfo1.getHostname()) || !"2".equals(hostInfo.getState())) continue;
                    fileWarnInfo1.setState(hostInfo.getState());
                }
                fileWarnInfo1.setHostname(fileWarnInfo1.getHostname() + HostUtil.addRemark((String)fileWarnInfo1.getHostname()));
                fileWarnInfo1.setWarnRows(FormatUtil.numToWStr((String)fileWarnInfo1.getWarnRows()));
            }
            PageUtil.initPageNumber((PageResultDto)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/fileWarnInfo/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef", e.toString(), "2");
        }
        return "file/list";
    }

    @RequestMapping(value={"save"})
    public String saveFileWarnInfo(FileWarnInfo fileWarnInfo, Model model, HttpServletRequest request) {
        try {
            AccountInfo accountInfoSession = HostUtil.getAccountByRequest((HttpServletRequest)request);
            if (!"admin".equals(accountInfoSession.getRole())) {
                logger.error("\u53ea\u6709\u7ba1\u7406\u5458\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
                return "error/500";
            }
            String blockKey = FormatUtil.haveBlockDanger((String)fileWarnInfo.getCustomShell(), (String)this.commonConfig.getShellToRunBlock());
            if (!StringUtils.isEmpty((CharSequence)blockKey)) {
                model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
                model.addAttribute("msg", (Object)("\u6307\u4ee4\u542b\u6709\u654f\u611f\u5b57\u7b26" + blockKey + "\uff0c\u8bf7\u68c0\u67e5"));
                this.fileWarnInfoService.getBlockStr(model);
                model.addAttribute("systemInfoList", (Object)StaticKeys.HOST_INFO_LIST);
                return "file/add";
            }
            if (StringUtils.isEmpty((CharSequence)fileWarnInfo.getId())) {
                fileWarnInfo.setWarnRows("0");
                fileWarnInfo.setFileSize("0");
                fileWarnInfo.setFileTotalNum("0");
                this.fileWarnInfoService.save(fileWarnInfo);
                this.fileWarnInfoService.saveLog(request, "\u6dfb\u52a0", fileWarnInfo);
            } else {
                this.fileWarnInfoService.updateById(fileWarnInfo);
                this.fileWarnInfoService.saveLog(request, "\u4fee\u6539", fileWarnInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u65e5\u5fd7\u76d1\u63a7\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u65e5\u5fd7\u76d1\u63a7\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/fileWarnInfo/list";
    }

    @RequestMapping(value={"saveBatch"})
    public String saveBatchFileWarnInfo(FileWarnInfo fileWarnInfo, Model model, HttpServletRequest request) {
        try {
            AccountInfo accountInfoSession = HostUtil.getAccountByRequest((HttpServletRequest)request);
            if (!"admin".equals(accountInfoSession.getRole())) {
                logger.error("\u53ea\u6709\u7ba1\u7406\u5458\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
                return "error/500";
            }
            String[] hostnames = request.getParameterValues("hostnames");
            if (null == hostnames || hostnames.length < 1) {
                return "redirect:/fileWarnInfo/list";
            }
            String blockKey = FormatUtil.haveBlockDanger((String)fileWarnInfo.getCustomShell(), (String)this.commonConfig.getShellToRunBlock());
            if (!StringUtils.isEmpty((CharSequence)blockKey)) {
                model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
                model.addAttribute("selectedHosts", (Object)hostnames);
                List hostInfoList = StaticKeys.HOST_INFO_LIST;
                for (HostInfo hostInfo : hostInfoList) {
                    for (String selectedHost : hostnames) {
                        if (!selectedHost.equals(hostInfo.getHostname())) continue;
                        hostInfo.setSelected("selected");
                    }
                }
                model.addAttribute("systemInfoList", (Object)hostInfoList);
                model.addAttribute("msg", (Object)("\u6307\u4ee4\u542b\u6709\u654f\u611f\u5b57\u7b26" + blockKey + "\uff0c\u8bf7\u68c0\u67e5"));
                this.fileWarnInfoService.getBlockStr(model);
                return "file/addBatch";
            }
            for (String selectedHost : hostnames) {
                fileWarnInfo.setHostname(selectedHost);
                fileWarnInfo.setWarnRows("0");
                fileWarnInfo.setFileSize("0");
                fileWarnInfo.setFileTotalNum("0");
                this.fileWarnInfoService.save(fileWarnInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u4fdd\u5b58\u65e5\u5fd7\u76d1\u63a7\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u6279\u91cf\u4fdd\u5b58\u65e5\u5fd7\u76d1\u63a7\u9519\u8bef", e.toString(), "2");
        }
        return "redirect:/fileWarnInfo/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u65e5\u5fd7\u76d1\u63a7";
        String id = request.getParameter("id");
        FileWarnInfo fileWarnInfo = new FileWarnInfo();
        try {
            this.fileWarnInfoService.getBlockStr(model);
            model.addAttribute("systemInfoList", (Object)StaticKeys.HOST_INFO_LIST);
            if (StringUtils.isEmpty((CharSequence)id)) {
                fileWarnInfo.setFileType("1");
                model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
                if (!this.isAddContinue()) {
                    return "redirect:/fileWarnInfo/list?liceFlage=1";
                }
                return "file/add";
            }
            fileWarnInfo = this.fileWarnInfoService.selectById(id);
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "file/add";
    }

    @RequestMapping(value={"updateActive"})
    public String updateActive(Model model, HttpServletRequest request) {
        String errorMsg = "\u6279\u91cf\u5f00\u59cb\u76d1\u63a7\u548c\u505c\u6b62\u76d1\u63a7\u9519\u8bef";
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids = request.getParameter("id").split(",");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("ids", ids);
                String activeValue = request.getParameter("active");
                params.put("active", activeValue);
                for (String id : ids) {
                    this.fileWarnInfoService.updateActive(id, activeValue);
                }
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/fileWarnInfo/list";
    }

    @RequestMapping(value={"editBatch"})
    public String editBatch(Model model, HttpServletRequest request) {
        String errorMsg = "\u6279\u91cf\u6dfb\u52a0\u65e5\u5fd7\u76d1\u63a7";
        FileWarnInfo fileWarnInfo = new FileWarnInfo();
        try {
            if (!StaticKeys.LICENSE_STATE.equals("1")) {
                return "redirect:/fileWarnInfo/list?liceFlage=2";
            }
            this.fileWarnInfoService.getBlockStr(model);
            model.addAttribute("systemInfoList", (Object)StaticKeys.HOST_INFO_LIST);
            fileWarnInfo.setFileType("1");
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "file/addBatch";
    }

    @RequestMapping(value={"view"})
    public String view(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770b\u65e5\u5fd7\u76d1\u63a7";
        String id = request.getParameter("id");
        FileWarnInfo fileWarnInfo = new FileWarnInfo();
        try {
            fileWarnInfo = this.fileWarnInfoService.selectById(id);
            model.addAttribute("fileWarnInfo", (Object)fileWarnInfo);
            this.messageErrorUtils.getCallBackMsgForShell(model, id, fileWarnInfo.getCustomShell());
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "file/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664\u65e5\u5fd7\u76d1\u63a7\u4fe1\u606f\u9519\u8bef";
        FileWarnInfo fileWarnInfo = new FileWarnInfo();
        try {
            AccountInfo accountInfoSession = HostUtil.getAccountByRequest((HttpServletRequest)request);
            if (!"admin".equals(accountInfoSession.getRole())) {
                logger.error("\u53ea\u6709\u7ba1\u7406\u5458\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
                return "error/500";
            }
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    fileWarnInfo = this.fileWarnInfoService.selectById(id);
                    this.logInfoService.save("\u5220\u9664\u65e5\u5fd7\u76d1\u63a7\uff1a" + fileWarnInfo.getHostname(), "\u5220\u9664\u65e5\u5fd7\u76d1\u63a7\uff1a" + fileWarnInfo.getHostname(), "2");
                }
                this.fileWarnInfoService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "2");
        }
        return "redirect:/fileWarnInfo/list";
    }

    private boolean isAddContinue() {
        try {
            long dbSize;
            if (!StaticKeys.LICENSE_STATE.equals("1") && (dbSize = this.fileWarnInfoService.countByParams(new ArrayList()).longValue()) >= 10L) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("isAddContinue error", (Throwable)e);
        }
        return true;
    }
}

