/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.LogInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.mongo.PageResultDto;
import com.wgcloud.util.mongo.ParamDto;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/log"})
public class LogInfoController {
    private static final Logger logger = LoggerFactory.getLogger(LogInfoController.class);
    @Resource
    private LogInfoService logInfoService;
    @Autowired
    private CommonConfig commonConfig;

    @RequestMapping(value={"list"})
    public String LogInfoList(LogInfo logInfo, Model model, HttpServletRequest request) {
        try {
            StringBuffer url = new StringBuffer();
            ArrayList<ParamDto> paramDtoList = new ArrayList<ParamDto>();
            String timeRange = request.getParameter("startTime");
            if (!StringUtils.isEmpty((CharSequence)logInfo.getHostname())) {
                url.append("&hostname=").append(logInfo.getHostname());
                paramDtoList.add(new ParamDto("hostname", "like", logInfo.getHostname().trim()));
            }
            if (!StringUtils.isEmpty((CharSequence)timeRange)) {
                String startTime = timeRange.split(" - ")[0].trim();
                String endTime = timeRange.split(" - ")[1].trim();
                paramDtoList.add(new ParamDto("createTime", "between", startTime + " 00:00:00" + "," + endTime + " 23:59:59"));
                url.append("&startTime=").append(timeRange);
                model.addAttribute("startTime", (Object)timeRange);
            }
            PageResultDto pageInfo = this.logInfoService.selectByParams(paramDtoList, logInfo.getPage().intValue(), logInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageResultDto)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/log/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("logInfo", (Object)logInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u5217\u8868\u9519\u8bef", (Throwable)e);
        }
        return "log/list";
    }

    @RequestMapping(value={"view"})
    public String viewLogInfo(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        LogInfo logInfo = new LogInfo();
        try {
            logInfo = this.logInfoService.selectById(id);
            model.addAttribute("logInfo", (Object)logInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u65e5\u5fd7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return "log/view";
    }
}

