/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.entity.DangerLogInfo;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.mongo.MongoBaseService;
import com.wgcloud.util.mongo.MongodbToolUtil;
import com.wgcloud.util.mongo.PageQueryDto;
import com.wgcloud.util.mongo.PageResultDto;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class DangerLogInfoService {
    private static final Logger logger = LoggerFactory.getLogger(DangerLogInfoService.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoBaseService mongoBaseService;

    public PageResultDto selectByParams(List paramDtoList, int currPage, int pageSize) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(pageSize));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(currPage));
        pageQueryDto.setParams(paramDtoList);
        PageResultDto result = MongodbToolUtil.selectByParams((PageQueryDto)pageQueryDto, DangerLogInfo.class, (MongoTemplate)this.mongoTemplate, (String)"_id", (String)"DESC", (String)"infoContent");
        return result;
    }

    public void save(String hostname, String logFileName, String infoContent, String warnChars, String remark) {
        DangerLogInfo dangerLogInfo = new DangerLogInfo();
        dangerLogInfo.setHostname(hostname);
        dangerLogInfo.setInfoContent(infoContent);
        if (StringUtils.isEmpty((CharSequence)remark)) {
            if (!StringUtils.isEmpty((CharSequence)infoContent)) {
                if (infoContent.length() > 50) {
                    dangerLogInfo.setTitle(infoContent.substring(0, 50) + "...");
                } else {
                    dangerLogInfo.setTitle(infoContent);
                }
            }
        } else {
            dangerLogInfo.setTitle(remark);
        }
        dangerLogInfo.setLogFileName(logFileName);
        dangerLogInfo.setId(UUIDUtil.getUUID());
        dangerLogInfo.setCreateTime(new Date());
        dangerLogInfo.setWarnChars(warnChars);
        try {
            dangerLogInfo.setLogSize(FormatUtil.getStrSize((String)infoContent));
            this.mongoBaseService.save((Object)dangerLogInfo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u544a\u8b66\u65e5\u5fd7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    public Long countByParams(List paramDtoList) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(10));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(1));
        pageQueryDto.setParams(paramDtoList);
        Query query = MongodbToolUtil.handleParam((PageQueryDto)pageQueryDto);
        long count = this.mongoTemplate.count(query, FileWarnInfo.class);
        return count;
    }

    public DangerLogInfo selectById(String id) throws Exception {
        return (DangerLogInfo)this.mongoTemplate.findById((Object)id, DangerLogInfo.class);
    }

    public List<DangerLogInfo> selectByIdArray(String ids) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        List<String> values = Arrays.asList(ids.split(","));
        criteria.and("_id").in(values);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"_id")}));
        return this.mongoTemplate.find(query, DangerLogInfo.class);
    }
}

