/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.FileWarnInfo;
import com.wgcloud.service.FileWarnStateService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.mongo.MongoBaseService;
import com.wgcloud.util.mongo.MongodbToolUtil;
import com.wgcloud.util.mongo.PageQueryDto;
import com.wgcloud.util.mongo.PageResultDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class FileWarnInfoService {
    private static final Logger logger = LoggerFactory.getLogger(FileWarnInfoService.class);
    @Autowired
    private FileWarnStateService fileWarnStateService;
    @Autowired
    private LogInfoService logInfoService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoBaseService mongoBaseService;
    @Autowired
    private CommonConfig commonConfig;

    public PageResultDto selectByParams(List paramDtoList, int currPage, int pageSize, String orderName, String orderType) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(pageSize));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(currPage));
        pageQueryDto.setParams(paramDtoList);
        PageResultDto result = MongodbToolUtil.selectByParams((PageQueryDto)pageQueryDto, FileWarnInfo.class, (MongoTemplate)this.mongoTemplate, (String)orderName, (String)orderType, (String)"");
        return result;
    }

    public List<FileWarnInfo> selectAllByParams() {
        try {
            return this.mongoBaseService.listByQuery(null, (Object)new FileWarnInfo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return new ArrayList<FileWarnInfo>();
        }
    }

    public List<FileWarnInfo> selectAllByParams(String hostName, String active) {
        try {
            Query query = new Query();
            Criteria criteria = new Criteria();
            criteria.and("hostname").is((Object)hostName);
            criteria.and("active").is((Object)active);
            query.addCriteria((CriteriaDefinition)criteria);
            return this.mongoBaseService.listByQuery(query, (Object)new FileWarnInfo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return new ArrayList<FileWarnInfo>();
        }
    }

    public void save(FileWarnInfo fileWarnInfo) throws Exception {
        fileWarnInfo.setId(UUIDUtil.getUUID());
        fileWarnInfo.setCreateTime(new Date());
        if (!StringUtils.isEmpty((CharSequence)fileWarnInfo.getFilePath())) {
            fileWarnInfo.setFilePath(fileWarnInfo.getFilePath().trim());
        }
        this.mongoBaseService.save((Object)fileWarnInfo);
    }

    public void updateActive(String id, String active) throws Exception {
        FileWarnInfo fileWarnInfo = new FileWarnInfo();
        fileWarnInfo.setActive(active);
        this.mongoBaseService.update((Object)fileWarnInfo, id);
    }

    public void saveLog(HttpServletRequest request, String action, FileWarnInfo fileWarnInfo) {
        if (null == fileWarnInfo) {
            return;
        }
        this.logInfoService.save("\u7ba1\u7406\u5458" + action + "\u65e5\u5fd7\u76d1\u63a7\uff1a" + fileWarnInfo.getHostname() + "\uff0c" + fileWarnInfo.getFilePath(), "\u6587\u4ef6\u8def\u5f84\uff1a" + fileWarnInfo.getFilePath(), "2");
    }

    public Long countByParams(List paramDtoList) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(10));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(1));
        pageQueryDto.setParams(paramDtoList);
        Query query = MongodbToolUtil.handleParam((PageQueryDto)pageQueryDto);
        long count = this.mongoTemplate.count(query, FileWarnInfo.class);
        return count;
    }

    public void deleteById(String[] id) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in((Object[])id));
        this.mongoTemplate.remove(query, FileWarnInfo.class);
    }

    public void deleteById(String id) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        this.mongoTemplate.remove(query, FileWarnInfo.class);
    }

    public void updateById(FileWarnInfo fileWarnInfo) throws Exception {
        this.mongoBaseService.update((Object)fileWarnInfo, fileWarnInfo.getId());
    }

    public FileWarnInfo selectById(String id) throws Exception {
        return (FileWarnInfo)this.mongoTemplate.findById((Object)id, FileWarnInfo.class);
    }

    public void getBlockStr(Model model) {
        String blockStr = "";
        if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getShellToRunBlock())) {
            blockStr = "[\u6307\u4ee4\u4e0d\u80fd\u5305\u542b\u654f\u611f\u5b57\u7b26:" + this.commonConfig.getShellToRunBlock() + "]";
        }
        model.addAttribute("blockStr", (Object)blockStr);
    }
}

