/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.mongo.MongoBaseService;
import com.wgcloud.util.mongo.MongodbToolUtil;
import com.wgcloud.util.mongo.PageQueryDto;
import com.wgcloud.util.mongo.PageResultDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class HostInfoService {
    private static final Logger logger = LoggerFactory.getLogger(HostInfoService.class);
    @Autowired
    private LogInfoService logInfoService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoBaseService mongoBaseService;
    @Autowired
    private CommonConfig commonConfig;

    public PageResultDto selectByParams(List paramDtoList, int currPage, int pageSize) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(pageSize));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(currPage));
        pageQueryDto.setParams(paramDtoList);
        PageResultDto result = MongodbToolUtil.selectByParams((PageQueryDto)pageQueryDto, HostInfo.class, (MongoTemplate)this.mongoTemplate, (String)"_id", (String)"DESC", (String)"");
        return result;
    }

    public List<HostInfo> selectAllByParams() {
        try {
            return this.mongoBaseService.listByQuery(null, (Object)new HostInfo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return new ArrayList<HostInfo>();
        }
    }

    public List<HostInfo> selectAllByParams(String hostName, String active) {
        try {
            Query query = new Query();
            Criteria criteria = new Criteria();
            criteria.and("hostname").is((Object)hostName);
            criteria.and("active").is((Object)active);
            query.addCriteria((CriteriaDefinition)criteria);
            return this.mongoBaseService.listByQuery(query, (Object)new HostInfo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return new ArrayList<HostInfo>();
        }
    }

    public void save(HostInfo hostInfo) {
        try {
            hostInfo.setId(UUIDUtil.getUUID());
            hostInfo.setCreateTime(new Date());
            this.mongoBaseService.save((Object)hostInfo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    public Long countByParams(List paramDtoList) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(10));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(1));
        pageQueryDto.setParams(paramDtoList);
        Query query = MongodbToolUtil.handleParam((PageQueryDto)pageQueryDto);
        long count = this.mongoTemplate.count(query, HostInfo.class);
        return count;
    }

    public void deleteById(String[] id) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in((Object[])id));
        this.mongoTemplate.remove(query, HostInfo.class);
    }

    public void deleteById(String id) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        this.mongoTemplate.remove(query, HostInfo.class);
    }

    public void updateById(HostInfo hostInfo) {
        try {
            this.mongoBaseService.update((Object)hostInfo, hostInfo.getId());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    public HostInfo selectById(String id) throws Exception {
        return (HostInfo)this.mongoTemplate.findById((Object)id, HostInfo.class);
    }
}

