/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.entity.OtherLogInfo;
import com.wgcloud.util.UUIDUtil;
import com.wgcloud.util.mongo.MongoBaseService;
import com.wgcloud.util.mongo.MongodbToolUtil;
import com.wgcloud.util.mongo.PageQueryDto;
import com.wgcloud.util.mongo.PageResultDto;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class OtherLogInfoService {
    private Logger logger = LoggerFactory.getLogger(OtherLogInfoService.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoBaseService mongoBaseService;

    public PageResultDto selectByParams(List paramDtoList, int currPage, int pageSize) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(pageSize));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(currPage));
        pageQueryDto.setParams(paramDtoList);
        PageResultDto result = MongodbToolUtil.selectByParams((PageQueryDto)pageQueryDto, OtherLogInfo.class, (MongoTemplate)this.mongoTemplate, (String)"_id", (String)"DESC", (String)"infoContent");
        return result;
    }

    public Long countByParams(List paramDtoList) throws Exception {
        PageQueryDto pageQueryDto = new PageQueryDto();
        pageQueryDto.setSize(Integer.valueOf(20));
        pageQueryDto.setCurrentPageNum(Integer.valueOf(1));
        pageQueryDto.setParams(paramDtoList);
        Query query = MongodbToolUtil.handleParam((PageQueryDto)pageQueryDto);
        long count = this.mongoTemplate.count(query, OtherLogInfo.class);
        return count;
    }

    public void save(OtherLogInfo otherLogInfo) {
        try {
            otherLogInfo.setId(UUIDUtil.getUUID());
            otherLogInfo.setCreateTime(new Date());
            this.mongoTemplate.save((Object)otherLogInfo);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
    }

    public void deleteById(String[] id) {
        try {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in((Object[])id));
            this.mongoTemplate.remove(query, OtherLogInfo.class);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u9519\u8bef", (Throwable)e);
        }
    }

    public OtherLogInfo selectById(String id) throws Exception {
        return (OtherLogInfo)this.mongoTemplate.findById((Object)id, OtherLogInfo.class);
    }

    public List<OtherLogInfo> selectByIdArray(String ids) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        List<String> values = Arrays.asList(ids.split(","));
        criteria.and("_id").in(values);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"_id")}));
        return this.mongoTemplate.find(query, OtherLogInfo.class);
    }
}

