/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.task;

import cn.hutool.core.collection.CollectionUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.DangerLogInfo;
import com.wgcloud.entity.FileWarnState;
import com.wgcloud.entity.HostInfo;
import com.wgcloud.entity.LogInfo;
import com.wgcloud.entity.LogSizeInfo;
import com.wgcloud.entity.MailSet;
import com.wgcloud.entity.OtherLogInfo;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.FileWarnStateService;
import com.wgcloud.service.HostInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.LogSizeInfoService;
import com.wgcloud.service.MailSetService;
import com.wgcloud.util.DESUtil;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.RestUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.mongo.MongoBaseService;
import com.wgcloud.util.msg.WarnOtherUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTask {
    private Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    @Autowired
    private LogInfoService logInfoService;
    @Autowired
    private MailSetService mailSetService;
    @Resource
    private DashboardService dashboardService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private RestUtil restUtil;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoBaseService mongoBaseService;
    @Autowired
    private HostInfoService hostInfoService;
    @Autowired
    private LogSizeInfoService logSizeInfoService;
    @Resource
    private FileWarnStateService fileWarnStateService;

    @Scheduled(initialDelay=5000L, fixedRate=86400000L)
    public void validateLicense() {
        this.logger.info("validateLicense-v1.4------------" + DateUtil.getDateTimeString((Date)new Date()));
        try {
            this.servletContext.setAttribute("icoUrl", (Object)(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/logincss/favicon.png"));
            this.servletContext.setAttribute("logoUrl", (Object)(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/static/logincss/logo.png"));
            this.servletContext.setAttribute("wgName", (Object)"WGLOG\u65e5\u5fd7\u5ba1\u8ba1\u7cfb\u7edf");
            this.servletContext.setAttribute("wgShortName", (Object)"WGLOG");
            StaticKeys.LICENSE_STATE = LicenseUtil.validateLicense((int)StaticKeys.HOST_INFO_LIST.size(), (int)this.commonConfig.getPageSize());
            this.servletContext.setAttribute("LICENSE_STATE", (Object)StaticKeys.LICENSE_STATE);
            this.servletContext.setAttribute("LICENSE_DATE", (Object)StaticKeys.LICENSE_DATE);
            this.servletContext.setAttribute("LICENSE_NAME", (Object)StaticKeys.LICENSE_NAME);
            if (!StringUtils.isEmpty((CharSequence)StaticKeys.LICENSE_DATE) && StaticKeys.LICENSE_DATE.startsWith("2099")) {
                this.servletContext.setAttribute("LICENSE_DATE", (Object)"\u6c38\u4e45\u6388\u6743");
            }
            if (StaticKeys.LICENSE_STATE.equals("0") && StaticKeys.HOST_INFO_LIST.size() > 10) {
                StaticKeys.LICENSE_STATE = "3";
            }
            this.servletContext.setAttribute("LICENSE_NUM", (Object)StaticKeys.LICENSE_NUM);
            this.servletContext.setAttribute("LICENSE_HIDE_VERSION", (Object)StaticKeys.LICENSE_HIDE_VERSION);
            this.servletContext.setAttribute("copyRight", (Object)"true");
            this.servletContext.setAttribute("copyRightLoginContent", (Object)"");
            this.servletContext.setAttribute("copyRightMainContent", (Object)"");
            if (StaticKeys.LICENSE_STATE.equals("1")) {
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getIcoName())) {
                    this.servletContext.setAttribute("icoUrl", (Object)(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/resources/" + this.commonConfig.getIcoName()));
                }
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getLogoName())) {
                    this.servletContext.setAttribute("logoUrl", (Object)(StaticKeys.SERVER_SERVLET_CONTEXT_PATH + "/resources/" + this.commonConfig.getLogoName()));
                }
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getWgName())) {
                    this.servletContext.setAttribute("wgName", (Object)this.commonConfig.getWgName());
                }
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getWgShortName())) {
                    this.servletContext.setAttribute("wgShortName", (Object)this.commonConfig.getWgShortName());
                }
                this.servletContext.setAttribute("copyRight", (Object)this.commonConfig.getCopyRight());
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getCopyRightLoginContent()) && "yes".equals(StaticKeys.LICENSE_COPYRIGHT_UPDATE)) {
                    this.servletContext.setAttribute("copyRightLoginContent", (Object)this.commonConfig.getCopyRightLoginContent());
                }
                if (!StringUtils.isEmpty((CharSequence)this.commonConfig.getCopyRightMainContent()) && "yes".equals(StaticKeys.LICENSE_COPYRIGHT_UPDATE)) {
                    this.servletContext.setAttribute("copyRightMainContent", (Object)this.commonConfig.getCopyRightMainContent());
                }
            }
            if (!(StaticKeys.LICENSE_STATE.equals("1") && "yes".equals(StaticKeys.LICENSE_DIY_CONTEXT_PATH) || "/wglog".equals(StaticKeys.SERVER_SERVLET_CONTEXT_PATH))) {
                StaticKeys.SERVER_SERVLET_CONTEXT_PATH = "";
                this.servletContext.setAttribute("SERVER_SERVLET_CONTEXT_PATH", (Object)"");
            }
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4blicense\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=20000L, fixedRate=360000L)
    public void initTask() {
        this.logger.info("initTask------------" + DateUtil.getDateTimeString((Date)new Date()));
        try {
            HashMap params = new HashMap();
            List list = this.mailSetService.selectAllByParams(params);
            if (list.size() > 0) {
                MailSet selectMailSet = (MailSet)list.get(0);
                if (!"2".equals(selectMailSet.getActive())) {
                    selectMailSet.setFromPwd(DESUtil.decryptForServerDb((String)selectMailSet.getFromPwd()));
                    StaticKeys.mailSet = selectMailSet;
                } else {
                    this.logger.info("\u5df2\u8bbe\u7f6e\u6682\u505c\u90ae\u4ef6\u544a\u8b66\u53d1\u9001");
                    StaticKeys.mailSet = null;
                }
            } else {
                StaticKeys.mailSet = null;
            }
            DateUtil.checkPwdExp((String)this.commonConfig.getPwdExpDate());
            StaticKeys.HOST_INFO_LIST.clear();
            StaticKeys.HOST_INFO_LIST = this.hostInfoService.selectAllByParams();
        }
        catch (Exception e) {
            this.logger.error("initTask\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=25000L, fixedRate=0x200B20L)
    public void handleFileWarnState() {
        try {
            long sumWarnState = this.mongoTemplate.getCollection("FILE_WARN_STATE").estimatedDocumentCount();
            sumWarnState += this.mongoTemplate.getCollection("OTHER_LOG_INFO").estimatedDocumentCount();
            for (HostInfo hostInfo : StaticKeys.HOST_INFO_LIST) {
                if (StringUtils.isEmpty((CharSequence)hostInfo.getNameSpace())) continue;
                sumWarnState += this.mongoTemplate.getCollection("FILE_WARN_STATE_" + hostInfo.getNameSpace()).estimatedDocumentCount();
            }
            String fileFormatSize = FormatUtil.numToWStr((Long)sumWarnState);
            this.servletContext.setAttribute("sumWarnState", (Object)fileFormatSize);
        }
        catch (Exception e) {
            this.logger.error("\u8ba1\u7b97\u603b\u7684\u91c7\u96c6\u6b21\u6570\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=30000L, fixedRate=3600000L)
    public void checkOutNumTask() {
        if (!"master".equals(this.commonConfig.getNodeType())) {
            this.logger.info("slave\u8282\u70b9\u4e0d\u6267\u884c\u68c0\u67e5\u4e3b\u673a\u662f\u5426\u5728\u7ebf\u4efb\u52a1");
            return;
        }
        try {
            if (StaticKeys.LICENSE_STATE.equals("3")) {
                Runnable runnable = () -> {
                    try {
                        WarnOtherUtil.sendUtil((String)"\u63d0\u793a\uff1a\u76d1\u63a7\u4e3b\u673a\u6570\u91cf\u5df2\u7ecf\u8d85\u8fc7\u514d\u8d39\u6388\u6743\u6570\u91cf", (String)("\u514d\u8d39\u4e2a\u4eba\u7248\u53ea\u80fd\u76d1\u63a710\u4e2a\u4e3b\u673a\uff0c\u5f53\u524d\u4e3b\u673a\u6570\u91cf\u4e3a" + StaticKeys.HOST_INFO_LIST.size() + "\uff0c\u8bf7\u5220\u51cf\u4e00\u4e9b\u4e3b\u673a\uff0c\u5982\u679c\u957f\u65f6\u95f4\u8d85\u8fc7\u6388\u6743\u4e3b\u673a\u6570\u91cf\uff0c\u65e5\u5fd7\u91c7\u96c6\u5de5\u4f5c\u53ef\u80fd\u4f1a\u505c\u6b62"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                };
                ThreadPoolUtil.executor.execute(runnable);
            }
        }
        catch (Exception e) {
            this.logger.error("checkOutNumTask\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=40000L, fixedRate=0x6DDD00L)
    public void checkHostStateTask() {
        if (!"master".equals(this.commonConfig.getNodeType())) {
            this.logger.info("slave\u8282\u70b9\u4e0d\u6267\u884c\u68c0\u67e5\u4e3b\u673a\u662f\u5426\u5728\u7ebf\u4efb\u52a1");
            return;
        }
        this.logger.info("\u68c0\u67e5\u4e3b\u673a\u662f\u5426\u5728\u7ebf----------" + DateUtil.getCurrentDateTime());
        try {
            Integer submitSeconds = 7260000;
            List hostList = this.hostInfoService.selectAllByParams();
            for (HostInfo hostInfo : hostList) {
                if ("2".equals(hostInfo.getState())) continue;
                Date createTime = hostInfo.getCreateTime();
                long diff = System.currentTimeMillis() - createTime.getTime();
                if (diff < (long)submitSeconds.intValue()) continue;
                HostInfo hostInfoTmp = new HostInfo();
                hostInfoTmp.setId(hostInfo.getId());
                hostInfoTmp.setState("2");
                this.hostInfoService.updateById(hostInfoTmp);
                Runnable runnable = () -> {
                    String title = "\u65e5\u5fd7\u91c7\u96c6\u4e3b\u673a\u5df2\u4e0b\u7ebf\uff1a" + hostInfo.getHostname();
                    String commContent = hostInfo.getHostname() + "\uff0c\u5df2\u7ecf\u8d85\u8fc72\u5c0f\u65f6\u672a\u4e0a\u62a5\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u91c7\u96c6\u7a0b\u5e8f\u662f\u5426\u6b63\u5e38\u8fd0\u884c";
                    WarnOtherUtil.sendUtil((String)title, (String)commContent);
                };
                ThreadPoolUtil.executor.execute(runnable);
            }
        }
        catch (Exception e) {
            this.logger.error("checkHostStateTask\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(cron="0 5 7 * * ?")
    public void clearHisdataTask() {
        this.logger.info("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u91c7\u96c6\u6570\u636e\u4efb\u52a1\u5f00\u59cb----------" + DateUtil.getCurrentDateTime());
        try {
            if (!"master".equals(this.commonConfig.getNodeType())) {
                this.logger.info("slave\u8282\u70b9\u4e0d\u6267\u884c\u6e05\u7a7a\u5386\u53f2\u76d1\u63a7\u6570\u636e\u4efb\u52a1");
                return;
            }
            this.logger.info("\u6e05\u7a7a\u767b\u5f55\u8d26\u53f7\u767b\u5f55\u9519\u8bef\u7f13\u5b58\u8bb0\u5f55");
            StaticKeys.LOGIN_BLOCK_MAP.clear();
            StaticKeys.LOGIN_ERROR_MAP.clear();
            StaticKeys.DAEMON_ERROR_MAP.clear();
            StaticKeys.MESSAGE_ERROR_MAP.clear();
            int historyDay = this.commonConfig.getHistoryDataOut();
            if (!StaticKeys.LICENSE_STATE.equals("1") && historyDay > 30) {
                this.logger.info("\u4e2a\u4eba\u7248\u4fdd\u7559\u6700\u8fd130\u5929\u7684\u65e5\u5fd7\u91c7\u96c6\u6570\u636e");
                historyDay = 30;
            }
            this.logger.info("\u6e05\u7a7a" + historyDay + "\u5929\u524d\u7684\u76d1\u63a7\u5386\u53f2\u65e5\u5fd7\u6570\u636e");
            String thrityDayBefore = DateUtil.getDateBefore((int)historyDay);
            Date dateDel = DateUtil.getDate((String)thrityDayBefore);
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"createTime").lt((Object)dateDel));
            this.mongoTemplate.remove(query, FileWarnState.class);
            this.mongoTemplate.remove(query, LogInfo.class);
            for (HostInfo hostInfo : StaticKeys.HOST_INFO_LIST) {
                if (StringUtils.isEmpty((CharSequence)hostInfo.getNameSpace())) continue;
                this.logger.info("\u6e05\u7a7aFILE_WARN_STATE_" + hostInfo.getNameSpace() + "\u76d1\u63a7\u5386\u53f2\u65e5\u5fd7\u6570\u636e");
                this.mongoTemplate.remove(query, "FILE_WARN_STATE_" + hostInfo.getNameSpace());
            }
            this.mongoTemplate.remove(query, OtherLogInfo.class);
            this.mongoTemplate.remove(query, LogSizeInfo.class);
            this.mongoTemplate.remove(query, DangerLogInfo.class);
        }
        catch (Exception e) {
            this.logger.error("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u91c7\u96c6\u6570\u636e\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u91c7\u96c6\u6570\u636e\u4efb\u52a1\u9519\u8bef", e.toString(), "2");
        }
        this.logger.info("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u91c7\u96c6\u6570\u636e\u4efb\u52a1\u7ed3\u675f----------" + DateUtil.getCurrentDateTime());
    }

    @Scheduled(initialDelay=50000L, fixedRate=1200000L)
    public void logSizeHourTask() {
        try {
            Long nowData = StaticKeys.LOG_SIZE_CACHE;
            Integer nowCount = StaticKeys.LOG_GATHER_COUNT_CACHE;
            StaticKeys.LOG_SIZE_CACHE = 0L;
            StaticKeys.LOG_GATHER_COUNT_CACHE = 0;
            List list = this.logSizeInfoService.selectAllByParams("_id", "DESC");
            String todayDate = DateUtil.getCurrentDate();
            if (CollectionUtil.isEmpty((Collection)list)) {
                this.logSizeInfoService.save(nowData + "");
            } else {
                LogSizeInfo logSizeInfo = (LogSizeInfo)list.get(0);
                if (todayDate.equals(logSizeInfo.getTodayDate())) {
                    LogSizeInfo updateLogSize = new LogSizeInfo();
                    updateLogSize.setId(logSizeInfo.getId());
                    Long oldData = 0L;
                    if (!StringUtils.isEmpty((CharSequence)logSizeInfo.getTodayLogSize())) {
                        oldData = Long.valueOf(logSizeInfo.getTodayLogSize());
                    }
                    Integer oldCount = logSizeInfo.getTodayLogCount();
                    if (null == logSizeInfo.getTodayLogCount()) {
                        oldCount = 0;
                    }
                    updateLogSize.setTodayLogSize(oldData + nowData + "");
                    updateLogSize.setTodayLogCount(Integer.valueOf(oldCount + nowCount));
                    this.logSizeInfoService.update(updateLogSize);
                } else {
                    this.logSizeInfoService.save(nowData + "");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("logSizeHourTask\u9519\u8bef", (Throwable)e);
        }
    }
}

