/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.mongo;

import cn.hutool.core.collection.CollectionUtil;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.mongo.PageQueryDto;
import com.wgcloud.util.mongo.PageResultDto;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

/*
 * Exception performing whole class analysis ignored.
 */
public class MongodbToolUtil {
    private static final Logger logger = LoggerFactory.getLogger(MongodbToolUtil.class);

    public static <T> PageResultDto<T> selectByParams(PageQueryDto dto, Class<T> tClass, MongoTemplate mongoTemplate, String orderName, String orderRules, String collectionName, String excludeField) {
        Query query = MongodbToolUtil.handleParam((PageQueryDto)dto);
        if (!StringUtils.isEmpty((CharSequence)excludeField)) {
            query.fields().exclude(excludeField);
        }
        if (!ObjectUtils.allNotNull((Object[])new Object[]{dto.getCurrentPageNum()})) {
            dto.setCurrentPageNum(Integer.valueOf(0));
        }
        if (!ObjectUtils.allNotNull((Object[])new Object[]{dto.getSize()})) {
            dto.setSize(Integer.valueOf(10));
        }
        long count = mongoTemplate.count(query, collectionName);
        int offset = (dto.getCurrentPageNum() - 1) * dto.getSize();
        if (StringUtils.isNotEmpty((CharSequence)orderName) && StringUtils.isNotEmpty((CharSequence)orderRules)) {
            String asc = "ASC";
            String desc = "DESC";
            if (asc.equals(orderRules)) {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)orderName)}));
            }
            if (desc.equals(orderRules)) {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)orderName)}));
            }
        }
        query.skip((long)offset).limit(dto.getSize().intValue());
        List list = mongoTemplate.find(query, tClass, collectionName);
        PageResultDto pageDTO = new PageResultDto();
        pageDTO.setTotal(Long.valueOf(count));
        pageDTO.setList(list);
        if (0 != dto.getSize()) {
            pageDTO.setPages(Long.valueOf((long)Math.ceil((double)count * 0.1 / (double)dto.getSize().intValue())));
        } else {
            pageDTO.setPages(Long.valueOf(0L));
        }
        pageDTO.setPageNum(dto.getCurrentPageNum());
        return pageDTO;
    }

    public static <T> PageResultDto<T> selectByParams(PageQueryDto dto, Class<T> tClass, MongoTemplate mongoTemplate, String orderName, String orderRules, String excludeField) {
        Query query = MongodbToolUtil.handleParam((PageQueryDto)dto);
        if (!StringUtils.isEmpty((CharSequence)excludeField)) {
            query.fields().exclude(excludeField);
        }
        if (!ObjectUtils.allNotNull((Object[])new Object[]{dto.getCurrentPageNum()})) {
            dto.setCurrentPageNum(Integer.valueOf(0));
        }
        if (!ObjectUtils.allNotNull((Object[])new Object[]{dto.getSize()})) {
            dto.setSize(Integer.valueOf(10));
        }
        long count = mongoTemplate.count(query, tClass);
        int offset = (dto.getCurrentPageNum() - 1) * dto.getSize();
        if (StringUtils.isEmpty((CharSequence)orderName)) {
            query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"_id")}));
        } else {
            if ("ASC".equals(orderRules)) {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)orderName)}));
            }
            if ("DESC".equals(orderRules)) {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)orderName)}));
            }
        }
        query.skip((long)offset).limit(dto.getSize().intValue());
        List list = mongoTemplate.find(query, tClass);
        PageResultDto pageDTO = new PageResultDto();
        pageDTO.setTotal(Long.valueOf(count));
        pageDTO.setList(list);
        if (0 != dto.getSize()) {
            pageDTO.setPages(Long.valueOf((count + (long)dto.getSize().intValue() - 1L) / (long)dto.getSize().intValue()));
        } else {
            pageDTO.setPages(Long.valueOf(0L));
        }
        pageDTO.setPageNum(dto.getCurrentPageNum());
        return pageDTO;
    }

    public static Query handleParam(PageQueryDto dto) {
        Query query = new Query();
        List params = dto.getParams();
        Criteria criteria = new Criteria();
        params.forEach(param -> {
            String operator;
            switch (operator = param.getOperator()) {
                case "eq": {
                    criteria.and(param.getFiled()).is((Object)param.getFiledValue());
                    break;
                }
                case "like": {
                    criteria.and(param.getFiled()).regex(Pattern.compile("^.*" + param.getFiledValue() + ".*$", 2));
                    break;
                }
                case "lte": {
                    criteria.and(param.getFiled()).lte((Object)param.getFiledValue());
                    break;
                }
                case "lt": {
                    criteria.and(param.getFiled()).lt((Object)param.getFiledValue());
                    break;
                }
                case "gt": {
                    criteria.and(param.getFiled()).gt((Object)param.getFiledValue());
                    break;
                }
                case "gte": {
                    criteria.and(param.getFiled()).gte((Object)param.getFiledValue());
                    break;
                }
                case "in": {
                    List<String> values = Arrays.asList(param.getFiledValue().split(","));
                    criteria.and(param.getFiled()).in(values);
                    break;
                }
                case "between": {
                    List<String> list = Arrays.asList(param.getFiledValue().split(","));
                    if (!CollectionUtil.isNotEmpty(list)) break;
                    try {
                        criteria.and(param.getFiled()).gte((Object)DateUtil.getDate((String)list.get(0))).lte((Object)DateUtil.getDate((String)list.get(1)));
                    }
                    catch (ParseException e) {
                        logger.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                    }
                    break;
                }
            }
        });
        query.addCriteria((CriteriaDefinition)criteria);
        return query;
    }
}

